package zio.aws.inspector.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.inspector.model.primitives.{ListMaxResults, PaginationToken}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAssessmentTargetsRequest(
    filter: Optional[zio.aws.inspector.model.AssessmentTargetFilter] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[ListMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsRequest = {
    import ListAssessmentTargetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsRequest
      .builder()
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ListMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.ListAssessmentTargetsRequest.ReadOnly =
    zio.aws.inspector.model.ListAssessmentTargetsRequest.wrap(buildAwsValue())
}
object ListAssessmentTargetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.ListAssessmentTargetsRequest =
      zio.aws.inspector.model.ListAssessmentTargetsRequest(
        filter.map(value => value.asEditable),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filter
        : Optional[zio.aws.inspector.model.AssessmentTargetFilter.ReadOnly]
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[ListMaxResults]
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.inspector.model.AssessmentTargetFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsRequest
  ) extends zio.aws.inspector.model.ListAssessmentTargetsRequest.ReadOnly {
    override val filter
        : Optional[zio.aws.inspector.model.AssessmentTargetFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value =>
          zio.aws.inspector.model.AssessmentTargetFilter.wrap(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector.model.primitives.PaginationToken(value))
    override val maxResults: Optional[ListMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.inspector.model.primitives.ListMaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsRequest
  ): zio.aws.inspector.model.ListAssessmentTargetsRequest.ReadOnly =
    new Wrapper(impl)
}
