package zio.aws.inspector.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateResourceGroupRequest(
    resourceGroupTags: Iterable[zio.aws.inspector.model.ResourceGroupTag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.CreateResourceGroupRequest = {
    import CreateResourceGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.CreateResourceGroupRequest
      .builder()
      .resourceGroupTags(resourceGroupTags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.CreateResourceGroupRequest.ReadOnly =
    zio.aws.inspector.model.CreateResourceGroupRequest.wrap(buildAwsValue())
}
object CreateResourceGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.CreateResourceGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.CreateResourceGroupRequest =
      zio.aws.inspector.model.CreateResourceGroupRequest(resourceGroupTags.map {
        item =>
          item.asEditable
      })
    def resourceGroupTags
        : List[zio.aws.inspector.model.ResourceGroupTag.ReadOnly]
    def getResourceGroupTags: ZIO[Any, Nothing, List[
      zio.aws.inspector.model.ResourceGroupTag.ReadOnly
    ]] = ZIO.succeed(resourceGroupTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.CreateResourceGroupRequest
  ) extends zio.aws.inspector.model.CreateResourceGroupRequest.ReadOnly {
    override val resourceGroupTags
        : List[zio.aws.inspector.model.ResourceGroupTag.ReadOnly] = impl
      .resourceGroupTags()
      .asScala
      .map { item =>
        zio.aws.inspector.model.ResourceGroupTag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.CreateResourceGroupRequest
  ): zio.aws.inspector.model.CreateResourceGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
