package zio.aws.inspector
import zio.prelude.Subtype
import zio.aws.inspector.model.primitives.{
  AgentId,
  AutoScalingGroup,
  Text,
  Ipv4Address,
  Arn,
  RuleName,
  AttributeKey,
  FindingCount
}
import java.time.Instant
import zio.aws.inspector.model.primitives.Version.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AgentId extends Subtype[String]
    type AgentId = zio.aws.inspector.model.primitives.AgentId.Type
    object AgentVersion extends Subtype[String]
    type AgentVersion = zio.aws.inspector.model.primitives.AgentVersion.Type
    object AmiId extends Subtype[String]
    type AmiId = zio.aws.inspector.model.primitives.AmiId.Type
    object Arn extends Subtype[String]
    type Arn = zio.aws.inspector.model.primitives.Arn.Type
    object ArnCount extends Subtype[Int]
    type ArnCount = zio.aws.inspector.model.primitives.ArnCount.Type
    object AssessmentRunDuration extends Subtype[Int]
    type AssessmentRunDuration =
      zio.aws.inspector.model.primitives.AssessmentRunDuration.Type
    object AssessmentRunName extends Subtype[String]
    type AssessmentRunName =
      zio.aws.inspector.model.primitives.AssessmentRunName.Type
    object AssessmentTargetName extends Subtype[String]
    type AssessmentTargetName =
      zio.aws.inspector.model.primitives.AssessmentTargetName.Type
    object AssessmentTemplateName extends Subtype[String]
    type AssessmentTemplateName =
      zio.aws.inspector.model.primitives.AssessmentTemplateName.Type
    object AttributeKey extends Subtype[String]
    type AttributeKey = zio.aws.inspector.model.primitives.AttributeKey.Type
    object AttributeValue extends Subtype[String]
    type AttributeValue = zio.aws.inspector.model.primitives.AttributeValue.Type
    object AutoScalingGroup extends Subtype[String]
    type AutoScalingGroup =
      zio.aws.inspector.model.primitives.AutoScalingGroup.Type
    type Bool = Boolean
    object FindingCount extends Subtype[Int]
    type FindingCount = zio.aws.inspector.model.primitives.FindingCount.Type
    object FindingId extends Subtype[String]
    type FindingId = zio.aws.inspector.model.primitives.FindingId.Type
    object Hostname extends Subtype[String]
    type Hostname = zio.aws.inspector.model.primitives.Hostname.Type
    object IocConfidence extends Subtype[Int]
    type IocConfidence = zio.aws.inspector.model.primitives.IocConfidence.Type
    object Ipv4Address extends Subtype[String]
    type Ipv4Address = zio.aws.inspector.model.primitives.Ipv4Address.Type
    object KernelVersion extends Subtype[String]
    type KernelVersion = zio.aws.inspector.model.primitives.KernelVersion.Type
    object ListEventSubscriptionsMaxResults extends Subtype[Int]
    type ListEventSubscriptionsMaxResults =
      zio.aws.inspector.model.primitives.ListEventSubscriptionsMaxResults.Type
    object ListMaxResults extends Subtype[Int]
    type ListMaxResults = zio.aws.inspector.model.primitives.ListMaxResults.Type
    object Message extends Subtype[String]
    type Message = zio.aws.inspector.model.primitives.Message.Type
    object MessageType extends Subtype[String]
    type MessageType = zio.aws.inspector.model.primitives.MessageType.Type
    object NamePattern extends Subtype[String]
    type NamePattern = zio.aws.inspector.model.primitives.NamePattern.Type
    object NumericSeverity extends Subtype[Double]
    type NumericSeverity =
      zio.aws.inspector.model.primitives.NumericSeverity.Type
    object NumericVersion extends Subtype[Int]
    type NumericVersion = zio.aws.inspector.model.primitives.NumericVersion.Type
    object OperatingSystem extends Subtype[String]
    type OperatingSystem =
      zio.aws.inspector.model.primitives.OperatingSystem.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken =
      zio.aws.inspector.model.primitives.PaginationToken.Type
    object PreviewAgentsMaxResults extends Subtype[Int]
    type PreviewAgentsMaxResults =
      zio.aws.inspector.model.primitives.PreviewAgentsMaxResults.Type
    object ProviderName extends Subtype[String]
    type ProviderName = zio.aws.inspector.model.primitives.ProviderName.Type
    object RuleName extends Subtype[String]
    type RuleName = zio.aws.inspector.model.primitives.RuleName.Type
    object RulesPackageName extends Subtype[String]
    type RulesPackageName =
      zio.aws.inspector.model.primitives.RulesPackageName.Type
    object ScopeValue extends Subtype[String]
    type ScopeValue = zio.aws.inspector.model.primitives.ScopeValue.Type
    object ServiceName extends Subtype[String]
    type ServiceName = zio.aws.inspector.model.primitives.ServiceName.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.inspector.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.inspector.model.primitives.TagValue.Type
    object Text extends Subtype[String]
    type Text = zio.aws.inspector.model.primitives.Text.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.inspector.model.primitives.Timestamp.Type
    object UUID extends Subtype[String]
    type UUID = zio.aws.inspector.model.primitives.UUID.Type
    object Url extends Subtype[String]
    type Url = zio.aws.inspector.model.primitives.Url.Type
    object Version extends Subtype[String]
    type Version = zio.aws.inspector.model.primitives.Version.Type
  }
  type AddRemoveAttributesFindingArnList = List[Arn]
  type AgentHealthCodeList = List[zio.aws.inspector.model.AgentHealthCode]
  type AgentHealthList = List[zio.aws.inspector.model.AgentHealth]
  type AgentIdList = List[AgentId]
  type AgentPreviewList = List[zio.aws.inspector.model.AgentPreview]
  type AssessmentRulesPackageArnList = List[Arn]
  type AssessmentRunAgentList = List[zio.aws.inspector.model.AssessmentRunAgent]
  type AssessmentRunFindingCounts =
    Map[zio.aws.inspector.model.Severity, FindingCount]
  type AssessmentRunList = List[zio.aws.inspector.model.AssessmentRun]
  type AssessmentRunNotificationList =
    List[zio.aws.inspector.model.AssessmentRunNotification]
  type AssessmentRunStateChangeList =
    List[zio.aws.inspector.model.AssessmentRunStateChange]
  type AssessmentRunStateList = List[zio.aws.inspector.model.AssessmentRunState]
  type AssessmentTargetList = List[zio.aws.inspector.model.AssessmentTarget]
  type AssessmentTemplateList = List[zio.aws.inspector.model.AssessmentTemplate]
  type AssessmentTemplateRulesPackageArnList = List[Arn]
  type AttributeList = List[zio.aws.inspector.model.Attribute]
  type AutoScalingGroupList = List[AutoScalingGroup]
  type BatchDescribeArnList = List[Arn]
  type BatchDescribeExclusionsArnList = List[Arn]
  type EventSubscriptionList = List[zio.aws.inspector.model.EventSubscription]
  type ExclusionMap = Map[Arn, zio.aws.inspector.model.Exclusion]
  type ExclusionPreviewList = List[zio.aws.inspector.model.ExclusionPreview]
  type FailedItems = Map[Arn, zio.aws.inspector.model.FailedItemDetails]
  type FilterRulesPackageArnList = List[Arn]
  type FindingList = List[zio.aws.inspector.model.Finding]
  type Ipv4AddressList = List[Ipv4Address]
  type Ipv6Addresses = List[Text]
  type ListParentArnList = List[Arn]
  type ListReturnedArnList = List[Arn]
  type NetworkInterfaces = List[zio.aws.inspector.model.NetworkInterface]
  type PrivateIpAddresses = List[zio.aws.inspector.model.PrivateIp]
  type ResourceGroupList = List[zio.aws.inspector.model.ResourceGroup]
  type ResourceGroupTags = List[zio.aws.inspector.model.ResourceGroupTag]
  type RuleNameList = List[RuleName]
  type RulesPackageList = List[zio.aws.inspector.model.RulesPackage]
  type ScopeList = List[zio.aws.inspector.model.Scope]
  type SecurityGroups = List[zio.aws.inspector.model.SecurityGroup]
  type SeverityList = List[zio.aws.inspector.model.Severity]
  type SubscriptionList = List[zio.aws.inspector.model.Subscription]
  type TagList = List[zio.aws.inspector.model.Tag]
  type Tags = List[zio.aws.inspector.model.Tag]
  type TelemetryMetadataList = List[zio.aws.inspector.model.TelemetryMetadata]
  type UserAttributeKeyList = List[AttributeKey]
  type UserAttributeList = List[zio.aws.inspector.model.Attribute]
}
