package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.{PaginationToken, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAssessmentTemplatesResponse(
    assessmentTemplateArns: Iterable[Arn],
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesResponse = {
    import ListAssessmentTemplatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesResponse
      .builder()
      .assessmentTemplateArns(assessmentTemplateArns.map { item =>
        Arn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.ListAssessmentTemplatesResponse.ReadOnly =
    zio.aws.inspector.model.ListAssessmentTemplatesResponse
      .wrap(buildAwsValue())
}
object ListAssessmentTemplatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.ListAssessmentTemplatesResponse =
      zio.aws.inspector.model.ListAssessmentTemplatesResponse(
        assessmentTemplateArns,
        nextToken.map(value => value)
      )
    def assessmentTemplateArns: List[Arn]
    def nextToken: Optional[PaginationToken]
    def getAssessmentTemplateArns: ZIO[Any, Nothing, List[Arn]] =
      ZIO.succeed(assessmentTemplateArns)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesResponse
  ) extends zio.aws.inspector.model.ListAssessmentTemplatesResponse.ReadOnly {
    override val assessmentTemplateArns: List[Arn] = impl
      .assessmentTemplateArns()
      .asScala
      .map { item =>
        zio.aws.inspector.model.primitives.Arn(item)
      }
      .toList
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesResponse
  ): zio.aws.inspector.model.ListAssessmentTemplatesResponse.ReadOnly =
    new Wrapper(impl)
}
