package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.{PaginationToken, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListFindingsResponse(
    findingArns: Iterable[Arn],
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.ListFindingsResponse = {
    import ListFindingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.ListFindingsResponse
      .builder()
      .findingArns(findingArns.map { item =>
        Arn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.ListFindingsResponse.ReadOnly =
    zio.aws.inspector.model.ListFindingsResponse.wrap(buildAwsValue())
}
object ListFindingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.ListFindingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.ListFindingsResponse =
      zio.aws.inspector.model
        .ListFindingsResponse(findingArns, nextToken.map(value => value))
    def findingArns: List[Arn]
    def nextToken: Optional[PaginationToken]
    def getFindingArns: ZIO[Any, Nothing, List[Arn]] = ZIO.succeed(findingArns)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.ListFindingsResponse
  ) extends zio.aws.inspector.model.ListFindingsResponse.ReadOnly {
    override val findingArns: List[Arn] = impl
      .findingArns()
      .asScala
      .map { item =>
        zio.aws.inspector.model.primitives.Arn(item)
      }
      .toList
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.ListFindingsResponse
  ): zio.aws.inspector.model.ListFindingsResponse.ReadOnly = new Wrapper(impl)
}
