package zio.aws.inspector.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.inspector.model.primitives.{ListMaxResults, PaginationToken, Arn}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListFindingsRequest(
    assessmentRunArns: Optional[Iterable[Arn]] = Optional.Absent,
    filter: Optional[zio.aws.inspector.model.FindingFilter] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[ListMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.ListFindingsRequest = {
    import ListFindingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.ListFindingsRequest
      .builder()
      .optionallyWith(
        assessmentRunArns.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.assessmentRunArns)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ListMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.ListFindingsRequest.ReadOnly =
    zio.aws.inspector.model.ListFindingsRequest.wrap(buildAwsValue())
}
object ListFindingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.ListFindingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.ListFindingsRequest =
      zio.aws.inspector.model.ListFindingsRequest(
        assessmentRunArns.map(value => value),
        filter.map(value => value.asEditable),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def assessmentRunArns: Optional[List[Arn]]
    def filter: Optional[zio.aws.inspector.model.FindingFilter.ReadOnly]
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[ListMaxResults]
    def getAssessmentRunArns: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("assessmentRunArns", assessmentRunArns)
    def getFilter
        : ZIO[Any, AwsError, zio.aws.inspector.model.FindingFilter.ReadOnly] =
      AwsError.unwrapOptionField("filter", filter)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.ListFindingsRequest
  ) extends zio.aws.inspector.model.ListFindingsRequest.ReadOnly {
    override val assessmentRunArns: Optional[List[Arn]] = zio.aws.core.internal
      .optionalFromNullable(impl.assessmentRunArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector.model.primitives.Arn(item)
        }.toList
      )
    override val filter
        : Optional[zio.aws.inspector.model.FindingFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.inspector.model.FindingFilter.wrap(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector.model.primitives.PaginationToken(value))
    override val maxResults: Optional[ListMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.inspector.model.primitives.ListMaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.ListFindingsRequest
  ): zio.aws.inspector.model.ListFindingsRequest.ReadOnly = new Wrapper(impl)
}
