package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Bool
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class FailedItemDetails(
    failureCode: zio.aws.inspector.model.FailedItemErrorCode,
    retryable: Bool
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.FailedItemDetails = {
    import FailedItemDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.FailedItemDetails
      .builder()
      .failureCode(failureCode.unwrap)
      .retryable(retryable: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.FailedItemDetails.ReadOnly =
    zio.aws.inspector.model.FailedItemDetails.wrap(buildAwsValue())
}
object FailedItemDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.FailedItemDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.FailedItemDetails =
      zio.aws.inspector.model.FailedItemDetails(failureCode, retryable)
    def failureCode: zio.aws.inspector.model.FailedItemErrorCode
    def retryable: Bool
    def getFailureCode
        : ZIO[Any, Nothing, zio.aws.inspector.model.FailedItemErrorCode] =
      ZIO.succeed(failureCode)
    def getRetryable: ZIO[Any, Nothing, Bool] = ZIO.succeed(retryable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.FailedItemDetails
  ) extends zio.aws.inspector.model.FailedItemDetails.ReadOnly {
    override val failureCode: zio.aws.inspector.model.FailedItemErrorCode =
      zio.aws.inspector.model.FailedItemErrorCode.wrap(impl.failureCode())
    override val retryable: Bool = impl.retryable(): Bool
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.FailedItemDetails
  ): zio.aws.inspector.model.FailedItemDetails.ReadOnly = new Wrapper(impl)
}
