package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Url
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetAssessmentReportResponse(
    status: zio.aws.inspector.model.ReportStatus,
    url: Optional[Url] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.GetAssessmentReportResponse = {
    import GetAssessmentReportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.GetAssessmentReportResponse
      .builder()
      .status(status.unwrap)
      .optionallyWith(url.map(value => Url.unwrap(value): java.lang.String))(
        _.url
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.GetAssessmentReportResponse.ReadOnly =
    zio.aws.inspector.model.GetAssessmentReportResponse.wrap(buildAwsValue())
}
object GetAssessmentReportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.GetAssessmentReportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.GetAssessmentReportResponse =
      zio.aws.inspector.model
        .GetAssessmentReportResponse(status, url.map(value => value))
    def status: zio.aws.inspector.model.ReportStatus
    def url: Optional[Url]
    def getStatus: ZIO[Any, Nothing, zio.aws.inspector.model.ReportStatus] =
      ZIO.succeed(status)
    def getUrl: ZIO[Any, AwsError, Url] = AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.GetAssessmentReportResponse
  ) extends zio.aws.inspector.model.GetAssessmentReportResponse.ReadOnly {
    override val status: zio.aws.inspector.model.ReportStatus =
      zio.aws.inspector.model.ReportStatus.wrap(impl.status())
    override val url: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => zio.aws.inspector.model.primitives.Url(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.GetAssessmentReportResponse
  ): zio.aws.inspector.model.GetAssessmentReportResponse.ReadOnly = new Wrapper(
    impl
  )
}
