package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.{Arn, NamePattern}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssessmentTemplateFilter(
    namePattern: Optional[NamePattern] = Optional.Absent,
    durationRange: Optional[zio.aws.inspector.model.DurationRange] =
      Optional.Absent,
    rulesPackageArns: Optional[Iterable[Arn]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.AssessmentTemplateFilter = {
    import AssessmentTemplateFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.AssessmentTemplateFilter
      .builder()
      .optionallyWith(
        namePattern.map(value => NamePattern.unwrap(value): java.lang.String)
      )(_.namePattern)
      .optionallyWith(durationRange.map(value => value.buildAwsValue()))(
        _.durationRange
      )
      .optionallyWith(
        rulesPackageArns.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.rulesPackageArns)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.AssessmentTemplateFilter.ReadOnly =
    zio.aws.inspector.model.AssessmentTemplateFilter.wrap(buildAwsValue())
}
object AssessmentTemplateFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.AssessmentTemplateFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.AssessmentTemplateFilter =
      zio.aws.inspector.model.AssessmentTemplateFilter(
        namePattern.map(value => value),
        durationRange.map(value => value.asEditable),
        rulesPackageArns.map(value => value)
      )
    def namePattern: Optional[NamePattern]
    def durationRange: Optional[zio.aws.inspector.model.DurationRange.ReadOnly]
    def rulesPackageArns: Optional[List[Arn]]
    def getNamePattern: ZIO[Any, AwsError, NamePattern] =
      AwsError.unwrapOptionField("namePattern", namePattern)
    def getDurationRange
        : ZIO[Any, AwsError, zio.aws.inspector.model.DurationRange.ReadOnly] =
      AwsError.unwrapOptionField("durationRange", durationRange)
    def getRulesPackageArns: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("rulesPackageArns", rulesPackageArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.AssessmentTemplateFilter
  ) extends zio.aws.inspector.model.AssessmentTemplateFilter.ReadOnly {
    override val namePattern: Optional[NamePattern] = zio.aws.core.internal
      .optionalFromNullable(impl.namePattern())
      .map(value => zio.aws.inspector.model.primitives.NamePattern(value))
    override val durationRange
        : Optional[zio.aws.inspector.model.DurationRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.durationRange())
        .map(value => zio.aws.inspector.model.DurationRange.wrap(value))
    override val rulesPackageArns: Optional[List[Arn]] = zio.aws.core.internal
      .optionalFromNullable(impl.rulesPackageArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector.model.primitives.Arn(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.AssessmentTemplateFilter
  ): zio.aws.inspector.model.AssessmentTemplateFilter.ReadOnly = new Wrapper(
    impl
  )
}
