package zio.aws.inspector.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.inspector.model.primitives.{ListMaxResults, PaginationToken, Arn}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListExclusionsRequest(
    assessmentRunArn: Arn,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[ListMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.ListExclusionsRequest = {
    import ListExclusionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.ListExclusionsRequest
      .builder()
      .assessmentRunArn(Arn.unwrap(assessmentRunArn): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ListMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.ListExclusionsRequest.ReadOnly =
    zio.aws.inspector.model.ListExclusionsRequest.wrap(buildAwsValue())
}
object ListExclusionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.ListExclusionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.ListExclusionsRequest =
      zio.aws.inspector.model.ListExclusionsRequest(
        assessmentRunArn,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def assessmentRunArn: Arn
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[ListMaxResults]
    def getAssessmentRunArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(assessmentRunArn)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.ListExclusionsRequest
  ) extends zio.aws.inspector.model.ListExclusionsRequest.ReadOnly {
    override val assessmentRunArn: Arn =
      zio.aws.inspector.model.primitives.Arn(impl.assessmentRunArn())
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector.model.primitives.PaginationToken(value))
    override val maxResults: Optional[ListMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.inspector.model.primitives.ListMaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.ListExclusionsRequest
  ): zio.aws.inspector.model.ListExclusionsRequest.ReadOnly = new Wrapper(impl)
}
