package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeExclusionsResponse(
    exclusions: Map[Arn, zio.aws.inspector.model.Exclusion],
    failedItems: Map[Arn, zio.aws.inspector.model.FailedItemDetails]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.DescribeExclusionsResponse = {
    import DescribeExclusionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.DescribeExclusionsResponse
      .builder()
      .exclusions(
        exclusions
          .map({ case (key, value) =>
            (Arn.unwrap(key): java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .failedItems(
        failedItems
          .map({ case (key, value) =>
            (Arn.unwrap(key): java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.DescribeExclusionsResponse.ReadOnly =
    zio.aws.inspector.model.DescribeExclusionsResponse.wrap(buildAwsValue())
}
object DescribeExclusionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.DescribeExclusionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.DescribeExclusionsResponse =
      zio.aws.inspector.model.DescribeExclusionsResponse(
        exclusions.map({ case (key, value) =>
          key -> value.asEditable
        }),
        failedItems.map({ case (key, value) =>
          key -> value.asEditable
        })
      )
    def exclusions: Map[Arn, zio.aws.inspector.model.Exclusion.ReadOnly]
    def failedItems
        : Map[Arn, zio.aws.inspector.model.FailedItemDetails.ReadOnly]
    def getExclusions: ZIO[Any, Nothing, Map[
      Arn,
      zio.aws.inspector.model.Exclusion.ReadOnly
    ]] = ZIO.succeed(exclusions)
    def getFailedItems: ZIO[Any, Nothing, Map[
      Arn,
      zio.aws.inspector.model.FailedItemDetails.ReadOnly
    ]] = ZIO.succeed(failedItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.DescribeExclusionsResponse
  ) extends zio.aws.inspector.model.DescribeExclusionsResponse.ReadOnly {
    override val exclusions
        : Map[Arn, zio.aws.inspector.model.Exclusion.ReadOnly] = impl
      .exclusions()
      .asScala
      .map({ case (key, value) =>
        zio.aws.inspector.model.primitives
          .Arn(key) -> zio.aws.inspector.model.Exclusion.wrap(value)
      })
      .toMap
    override val failedItems
        : Map[Arn, zio.aws.inspector.model.FailedItemDetails.ReadOnly] = impl
      .failedItems()
      .asScala
      .map({ case (key, value) =>
        zio.aws.inspector.model.primitives
          .Arn(key) -> zio.aws.inspector.model.FailedItemDetails.wrap(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.DescribeExclusionsResponse
  ): zio.aws.inspector.model.DescribeExclusionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
