package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PreviewAgentsResponse(
    agentPreviews: Iterable[zio.aws.inspector.model.AgentPreview],
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.PreviewAgentsResponse = {
    import PreviewAgentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.PreviewAgentsResponse
      .builder()
      .agentPreviews(agentPreviews.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.PreviewAgentsResponse.ReadOnly =
    zio.aws.inspector.model.PreviewAgentsResponse.wrap(buildAwsValue())
}
object PreviewAgentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.PreviewAgentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.PreviewAgentsResponse =
      zio.aws.inspector.model.PreviewAgentsResponse(
        agentPreviews.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def agentPreviews: List[zio.aws.inspector.model.AgentPreview.ReadOnly]
    def nextToken: Optional[PaginationToken]
    def getAgentPreviews: ZIO[Any, Nothing, List[
      zio.aws.inspector.model.AgentPreview.ReadOnly
    ]] = ZIO.succeed(agentPreviews)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.PreviewAgentsResponse
  ) extends zio.aws.inspector.model.PreviewAgentsResponse.ReadOnly {
    override val agentPreviews
        : List[zio.aws.inspector.model.AgentPreview.ReadOnly] = impl
      .agentPreviews()
      .asScala
      .map { item =>
        zio.aws.inspector.model.AgentPreview.wrap(item)
      }
      .toList
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.PreviewAgentsResponse
  ): zio.aws.inspector.model.PreviewAgentsResponse.ReadOnly = new Wrapper(impl)
}
