package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UnsubscribeFromEventRequest(
    resourceArn: Arn,
    event: zio.aws.inspector.model.InspectorEvent,
    topicArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.UnsubscribeFromEventRequest = {
    import UnsubscribeFromEventRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.UnsubscribeFromEventRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .event(event.unwrap)
      .topicArn(Arn.unwrap(topicArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.UnsubscribeFromEventRequest.ReadOnly =
    zio.aws.inspector.model.UnsubscribeFromEventRequest.wrap(buildAwsValue())
}
object UnsubscribeFromEventRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.UnsubscribeFromEventRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.UnsubscribeFromEventRequest =
      zio.aws.inspector.model
        .UnsubscribeFromEventRequest(resourceArn, event, topicArn)
    def resourceArn: Arn
    def event: zio.aws.inspector.model.InspectorEvent
    def topicArn: Arn
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getEvent: ZIO[Any, Nothing, zio.aws.inspector.model.InspectorEvent] =
      ZIO.succeed(event)
    def getTopicArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(topicArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.UnsubscribeFromEventRequest
  ) extends zio.aws.inspector.model.UnsubscribeFromEventRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.inspector.model.primitives.Arn(impl.resourceArn())
    override val event: zio.aws.inspector.model.InspectorEvent =
      zio.aws.inspector.model.InspectorEvent.wrap(impl.event())
    override val topicArn: Arn =
      zio.aws.inspector.model.primitives.Arn(impl.topicArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.UnsubscribeFromEventRequest
  ): zio.aws.inspector.model.UnsubscribeFromEventRequest.ReadOnly = new Wrapper(
    impl
  )
}
