package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteAssessmentTemplateRequest(assessmentTemplateArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.DeleteAssessmentTemplateRequest = {
    import DeleteAssessmentTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.DeleteAssessmentTemplateRequest
      .builder()
      .assessmentTemplateArn(
        Arn.unwrap(assessmentTemplateArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.DeleteAssessmentTemplateRequest.ReadOnly =
    zio.aws.inspector.model.DeleteAssessmentTemplateRequest
      .wrap(buildAwsValue())
}
object DeleteAssessmentTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.DeleteAssessmentTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.DeleteAssessmentTemplateRequest =
      zio.aws.inspector.model
        .DeleteAssessmentTemplateRequest(assessmentTemplateArn)
    def assessmentTemplateArn: Arn
    def getAssessmentTemplateArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(assessmentTemplateArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.DeleteAssessmentTemplateRequest
  ) extends zio.aws.inspector.model.DeleteAssessmentTemplateRequest.ReadOnly {
    override val assessmentTemplateArn: Arn =
      zio.aws.inspector.model.primitives.Arn(impl.assessmentTemplateArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.DeleteAssessmentTemplateRequest
  ): zio.aws.inspector.model.DeleteAssessmentTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
