package zio.aws.inspector.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AgentFilter(
    agentHealths: Iterable[zio.aws.inspector.model.AgentHealth],
    agentHealthCodes: Iterable[zio.aws.inspector.model.AgentHealthCode]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.AgentFilter = {
    import AgentFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.AgentFilter
      .builder()
      .agentHealthsWithStrings(agentHealths.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .agentHealthCodesWithStrings(agentHealthCodes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.AgentFilter.ReadOnly =
    zio.aws.inspector.model.AgentFilter.wrap(buildAwsValue())
}
object AgentFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.AgentFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.AgentFilter =
      zio.aws.inspector.model.AgentFilter(agentHealths, agentHealthCodes)
    def agentHealths: List[zio.aws.inspector.model.AgentHealth]
    def agentHealthCodes: List[zio.aws.inspector.model.AgentHealthCode]
    def getAgentHealths
        : ZIO[Any, Nothing, List[zio.aws.inspector.model.AgentHealth]] =
      ZIO.succeed(agentHealths)
    def getAgentHealthCodes
        : ZIO[Any, Nothing, List[zio.aws.inspector.model.AgentHealthCode]] =
      ZIO.succeed(agentHealthCodes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.AgentFilter
  ) extends zio.aws.inspector.model.AgentFilter.ReadOnly {
    override val agentHealths: List[zio.aws.inspector.model.AgentHealth] = impl
      .agentHealths()
      .asScala
      .map { item =>
        zio.aws.inspector.model.AgentHealth.wrap(item)
      }
      .toList
    override val agentHealthCodes
        : List[zio.aws.inspector.model.AgentHealthCode] = impl
      .agentHealthCodes()
      .asScala
      .map { item =>
        zio.aws.inspector.model.AgentHealthCode.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.AgentFilter
  ): zio.aws.inspector.model.AgentFilter.ReadOnly = new Wrapper(impl)
}
