package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeRulesPackagesResponse(
    rulesPackages: Iterable[zio.aws.inspector.model.RulesPackage],
    failedItems: Map[Arn, zio.aws.inspector.model.FailedItemDetails]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.DescribeRulesPackagesResponse = {
    import DescribeRulesPackagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.DescribeRulesPackagesResponse
      .builder()
      .rulesPackages(rulesPackages.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .failedItems(
        failedItems
          .map({ case (key, value) =>
            (Arn.unwrap(key): java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.DescribeRulesPackagesResponse.ReadOnly =
    zio.aws.inspector.model.DescribeRulesPackagesResponse.wrap(buildAwsValue())
}
object DescribeRulesPackagesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.DescribeRulesPackagesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.DescribeRulesPackagesResponse =
      zio.aws.inspector.model.DescribeRulesPackagesResponse(
        rulesPackages.map { item =>
          item.asEditable
        },
        failedItems.map({ case (key, value) =>
          key -> value.asEditable
        })
      )
    def rulesPackages: List[zio.aws.inspector.model.RulesPackage.ReadOnly]
    def failedItems
        : Map[Arn, zio.aws.inspector.model.FailedItemDetails.ReadOnly]
    def getRulesPackages: ZIO[Any, Nothing, List[
      zio.aws.inspector.model.RulesPackage.ReadOnly
    ]] = ZIO.succeed(rulesPackages)
    def getFailedItems: ZIO[Any, Nothing, Map[
      Arn,
      zio.aws.inspector.model.FailedItemDetails.ReadOnly
    ]] = ZIO.succeed(failedItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.DescribeRulesPackagesResponse
  ) extends zio.aws.inspector.model.DescribeRulesPackagesResponse.ReadOnly {
    override val rulesPackages
        : List[zio.aws.inspector.model.RulesPackage.ReadOnly] = impl
      .rulesPackages()
      .asScala
      .map { item =>
        zio.aws.inspector.model.RulesPackage.wrap(item)
      }
      .toList
    override val failedItems
        : Map[Arn, zio.aws.inspector.model.FailedItemDetails.ReadOnly] = impl
      .failedItems()
      .asScala
      .map({ case (key, value) =>
        zio.aws.inspector.model.primitives
          .Arn(key) -> zio.aws.inspector.model.FailedItemDetails.wrap(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.DescribeRulesPackagesResponse
  ): zio.aws.inspector.model.DescribeRulesPackagesResponse.ReadOnly =
    new Wrapper(impl)
}
