package zio.aws.inspector.model
import scala.jdk.CollectionConverters._
sealed trait AssessmentRunState {
  def unwrap: software.amazon.awssdk.services.inspector.model.AssessmentRunState
}
object AssessmentRunState {
  def wrap(
      value: software.amazon.awssdk.services.inspector.model.AssessmentRunState
  ): zio.aws.inspector.model.AssessmentRunState = value match {
    case software.amazon.awssdk.services.inspector.model.AssessmentRunState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector.model.AssessmentRunState.CREATED =>
      val r = CREATED
      r
    case software.amazon.awssdk.services.inspector.model.AssessmentRunState.START_DATA_COLLECTION_PENDING =>
      val r = START_DATA_COLLECTION_PENDING
      r
    case software.amazon.awssdk.services.inspector.model.AssessmentRunState.START_DATA_COLLECTION_IN_PROGRESS =>
      val r = START_DATA_COLLECTION_IN_PROGRESS
      r
    case software.amazon.awssdk.services.inspector.model.AssessmentRunState.COLLECTING_DATA =>
      val r = COLLECTING_DATA
      r
    case software.amazon.awssdk.services.inspector.model.AssessmentRunState.STOP_DATA_COLLECTION_PENDING =>
      val r = STOP_DATA_COLLECTION_PENDING
      r
    case software.amazon.awssdk.services.inspector.model.AssessmentRunState.DATA_COLLECTED =>
      val r = DATA_COLLECTED
      r
    case software.amazon.awssdk.services.inspector.model.AssessmentRunState.START_EVALUATING_RULES_PENDING =>
      val r = START_EVALUATING_RULES_PENDING
      r
    case software.amazon.awssdk.services.inspector.model.AssessmentRunState.EVALUATING_RULES =>
      val r = EVALUATING_RULES
      r
    case software.amazon.awssdk.services.inspector.model.AssessmentRunState.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.inspector.model.AssessmentRunState.ERROR =>
      val r = ERROR
      r
    case software.amazon.awssdk.services.inspector.model.AssessmentRunState.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.inspector.model.AssessmentRunState.COMPLETED_WITH_ERRORS =>
      val r = COMPLETED_WITH_ERRORS
      r
    case software.amazon.awssdk.services.inspector.model.AssessmentRunState.CANCELED =>
      val r = CANCELED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector.model.AssessmentRunState {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.AssessmentRunState =
      software.amazon.awssdk.services.inspector.model.AssessmentRunState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATED extends zio.aws.inspector.model.AssessmentRunState {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.AssessmentRunState =
      software.amazon.awssdk.services.inspector.model.AssessmentRunState.CREATED
  }
  case object START_DATA_COLLECTION_PENDING
      extends zio.aws.inspector.model.AssessmentRunState {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.AssessmentRunState =
      software.amazon.awssdk.services.inspector.model.AssessmentRunState.START_DATA_COLLECTION_PENDING
  }
  case object START_DATA_COLLECTION_IN_PROGRESS
      extends zio.aws.inspector.model.AssessmentRunState {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.AssessmentRunState =
      software.amazon.awssdk.services.inspector.model.AssessmentRunState.START_DATA_COLLECTION_IN_PROGRESS
  }
  case object COLLECTING_DATA
      extends zio.aws.inspector.model.AssessmentRunState {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.AssessmentRunState =
      software.amazon.awssdk.services.inspector.model.AssessmentRunState.COLLECTING_DATA
  }
  case object STOP_DATA_COLLECTION_PENDING
      extends zio.aws.inspector.model.AssessmentRunState {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.AssessmentRunState =
      software.amazon.awssdk.services.inspector.model.AssessmentRunState.STOP_DATA_COLLECTION_PENDING
  }
  case object DATA_COLLECTED
      extends zio.aws.inspector.model.AssessmentRunState {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.AssessmentRunState =
      software.amazon.awssdk.services.inspector.model.AssessmentRunState.DATA_COLLECTED
  }
  case object START_EVALUATING_RULES_PENDING
      extends zio.aws.inspector.model.AssessmentRunState {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.AssessmentRunState =
      software.amazon.awssdk.services.inspector.model.AssessmentRunState.START_EVALUATING_RULES_PENDING
  }
  case object EVALUATING_RULES
      extends zio.aws.inspector.model.AssessmentRunState {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.AssessmentRunState =
      software.amazon.awssdk.services.inspector.model.AssessmentRunState.EVALUATING_RULES
  }
  case object FAILED extends zio.aws.inspector.model.AssessmentRunState {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.AssessmentRunState =
      software.amazon.awssdk.services.inspector.model.AssessmentRunState.FAILED
  }
  case object ERROR extends zio.aws.inspector.model.AssessmentRunState {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.AssessmentRunState =
      software.amazon.awssdk.services.inspector.model.AssessmentRunState.ERROR
  }
  case object COMPLETED extends zio.aws.inspector.model.AssessmentRunState {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.AssessmentRunState =
      software.amazon.awssdk.services.inspector.model.AssessmentRunState.COMPLETED
  }
  case object COMPLETED_WITH_ERRORS
      extends zio.aws.inspector.model.AssessmentRunState {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.AssessmentRunState =
      software.amazon.awssdk.services.inspector.model.AssessmentRunState.COMPLETED_WITH_ERRORS
  }
  case object CANCELED extends zio.aws.inspector.model.AssessmentRunState {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.AssessmentRunState =
      software.amazon.awssdk.services.inspector.model.AssessmentRunState.CANCELED
  }
}
