package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RegisterCrossAccountAccessRoleRequest(roleArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.RegisterCrossAccountAccessRoleRequest = {
    import RegisterCrossAccountAccessRoleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.RegisterCrossAccountAccessRoleRequest
      .builder()
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.RegisterCrossAccountAccessRoleRequest.ReadOnly =
    zio.aws.inspector.model.RegisterCrossAccountAccessRoleRequest
      .wrap(buildAwsValue())
}
object RegisterCrossAccountAccessRoleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.RegisterCrossAccountAccessRoleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector.model.RegisterCrossAccountAccessRoleRequest =
      zio.aws.inspector.model.RegisterCrossAccountAccessRoleRequest(roleArn)
    def roleArn: Arn
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.RegisterCrossAccountAccessRoleRequest
  ) extends zio.aws.inspector.model.RegisterCrossAccountAccessRoleRequest.ReadOnly {
    override val roleArn: Arn =
      zio.aws.inspector.model.primitives.Arn(impl.roleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.RegisterCrossAccountAccessRoleRequest
  ): zio.aws.inspector.model.RegisterCrossAccountAccessRoleRequest.ReadOnly =
    new Wrapper(impl)
}
