package zio.aws.inspector.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.inspector.model.primitives.{
  ListEventSubscriptionsMaxResults,
  PaginationToken,
  Arn
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListEventSubscriptionsRequest(
    resourceArn: Optional[Arn] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[ListEventSubscriptionsMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsRequest = {
    import ListEventSubscriptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsRequest
      .builder()
      .optionallyWith(
        resourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          ListEventSubscriptionsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.ListEventSubscriptionsRequest.ReadOnly =
    zio.aws.inspector.model.ListEventSubscriptionsRequest.wrap(buildAwsValue())
}
object ListEventSubscriptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.ListEventSubscriptionsRequest =
      zio.aws.inspector.model.ListEventSubscriptionsRequest(
        resourceArn.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def resourceArn: Optional[Arn]
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[ListEventSubscriptionsMaxResults]
    def getResourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListEventSubscriptionsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsRequest
  ) extends zio.aws.inspector.model.ListEventSubscriptionsRequest.ReadOnly {
    override val resourceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.inspector.model.primitives.Arn(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector.model.primitives.PaginationToken(value))
    override val maxResults: Optional[ListEventSubscriptionsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.inspector.model.primitives
            .ListEventSubscriptionsMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsRequest
  ): zio.aws.inspector.model.ListEventSubscriptionsRequest.ReadOnly =
    new Wrapper(impl)
}
