package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.{Text, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Exclusion(
    arn: Arn,
    title: Text,
    description: Text,
    recommendation: Text,
    scopes: Iterable[zio.aws.inspector.model.Scope],
    attributes: Optional[Iterable[zio.aws.inspector.model.Attribute]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.Exclusion = {
    import Exclusion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.Exclusion
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .title(Text.unwrap(title): java.lang.String)
      .description(Text.unwrap(description): java.lang.String)
      .recommendation(Text.unwrap(recommendation): java.lang.String)
      .scopes(scopes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.Exclusion.ReadOnly =
    zio.aws.inspector.model.Exclusion.wrap(buildAwsValue())
}
object Exclusion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.Exclusion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.Exclusion =
      zio.aws.inspector.model.Exclusion(
        arn,
        title,
        description,
        recommendation,
        scopes.map { item =>
          item.asEditable
        },
        attributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def arn: Arn
    def title: Text
    def description: Text
    def recommendation: Text
    def scopes: List[zio.aws.inspector.model.Scope.ReadOnly]
    def attributes: Optional[List[zio.aws.inspector.model.Attribute.ReadOnly]]
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getTitle: ZIO[Any, Nothing, Text] = ZIO.succeed(title)
    def getDescription: ZIO[Any, Nothing, Text] = ZIO.succeed(description)
    def getRecommendation: ZIO[Any, Nothing, Text] = ZIO.succeed(recommendation)
    def getScopes
        : ZIO[Any, Nothing, List[zio.aws.inspector.model.Scope.ReadOnly]] =
      ZIO.succeed(scopes)
    def getAttributes
        : ZIO[Any, AwsError, List[zio.aws.inspector.model.Attribute.ReadOnly]] =
      AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.Exclusion
  ) extends zio.aws.inspector.model.Exclusion.ReadOnly {
    override val arn: Arn = zio.aws.inspector.model.primitives.Arn(impl.arn())
    override val title: Text =
      zio.aws.inspector.model.primitives.Text(impl.title())
    override val description: Text =
      zio.aws.inspector.model.primitives.Text(impl.description())
    override val recommendation: Text =
      zio.aws.inspector.model.primitives.Text(impl.recommendation())
    override val scopes: List[zio.aws.inspector.model.Scope.ReadOnly] = impl
      .scopes()
      .asScala
      .map { item =>
        zio.aws.inspector.model.Scope.wrap(item)
      }
      .toList
    override val attributes
        : Optional[List[zio.aws.inspector.model.Attribute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector.model.Attribute.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.Exclusion
  ): zio.aws.inspector.model.Exclusion.ReadOnly = new Wrapper(impl)
}
