package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.{
  Arn,
  RuleName,
  AutoScalingGroup,
  AgentId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FindingFilter(
    agentIds: Optional[Iterable[AgentId]] = Optional.Absent,
    autoScalingGroups: Optional[Iterable[AutoScalingGroup]] = Optional.Absent,
    ruleNames: Optional[Iterable[RuleName]] = Optional.Absent,
    severities: Optional[Iterable[zio.aws.inspector.model.Severity]] =
      Optional.Absent,
    rulesPackageArns: Optional[Iterable[Arn]] = Optional.Absent,
    attributes: Optional[Iterable[zio.aws.inspector.model.Attribute]] =
      Optional.Absent,
    userAttributes: Optional[Iterable[zio.aws.inspector.model.Attribute]] =
      Optional.Absent,
    creationTimeRange: Optional[zio.aws.inspector.model.TimestampRange] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.FindingFilter = {
    import FindingFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.FindingFilter
      .builder()
      .optionallyWith(
        agentIds.map(value =>
          value.map { item =>
            AgentId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.agentIds)
      .optionallyWith(
        autoScalingGroups.map(value =>
          value.map { item =>
            AutoScalingGroup.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.autoScalingGroups)
      .optionallyWith(
        ruleNames.map(value =>
          value.map { item =>
            RuleName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ruleNames)
      .optionallyWith(
        severities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.severitiesWithStrings)
      .optionallyWith(
        rulesPackageArns.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.rulesPackageArns)
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .optionallyWith(
        userAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userAttributes)
      .optionallyWith(creationTimeRange.map(value => value.buildAwsValue()))(
        _.creationTimeRange
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.FindingFilter.ReadOnly =
    zio.aws.inspector.model.FindingFilter.wrap(buildAwsValue())
}
object FindingFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.FindingFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.FindingFilter =
      zio.aws.inspector.model.FindingFilter(
        agentIds.map(value => value),
        autoScalingGroups.map(value => value),
        ruleNames.map(value => value),
        severities.map(value => value),
        rulesPackageArns.map(value => value),
        attributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creationTimeRange.map(value => value.asEditable)
      )
    def agentIds: Optional[List[AgentId]]
    def autoScalingGroups: Optional[List[AutoScalingGroup]]
    def ruleNames: Optional[List[RuleName]]
    def severities: Optional[List[zio.aws.inspector.model.Severity]]
    def rulesPackageArns: Optional[List[Arn]]
    def attributes: Optional[List[zio.aws.inspector.model.Attribute.ReadOnly]]
    def userAttributes
        : Optional[List[zio.aws.inspector.model.Attribute.ReadOnly]]
    def creationTimeRange
        : Optional[zio.aws.inspector.model.TimestampRange.ReadOnly]
    def getAgentIds: ZIO[Any, AwsError, List[AgentId]] =
      AwsError.unwrapOptionField("agentIds", agentIds)
    def getAutoScalingGroups: ZIO[Any, AwsError, List[AutoScalingGroup]] =
      AwsError.unwrapOptionField("autoScalingGroups", autoScalingGroups)
    def getRuleNames: ZIO[Any, AwsError, List[RuleName]] =
      AwsError.unwrapOptionField("ruleNames", ruleNames)
    def getSeverities
        : ZIO[Any, AwsError, List[zio.aws.inspector.model.Severity]] =
      AwsError.unwrapOptionField("severities", severities)
    def getRulesPackageArns: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("rulesPackageArns", rulesPackageArns)
    def getAttributes
        : ZIO[Any, AwsError, List[zio.aws.inspector.model.Attribute.ReadOnly]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getUserAttributes
        : ZIO[Any, AwsError, List[zio.aws.inspector.model.Attribute.ReadOnly]] =
      AwsError.unwrapOptionField("userAttributes", userAttributes)
    def getCreationTimeRange
        : ZIO[Any, AwsError, zio.aws.inspector.model.TimestampRange.ReadOnly] =
      AwsError.unwrapOptionField("creationTimeRange", creationTimeRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.FindingFilter
  ) extends zio.aws.inspector.model.FindingFilter.ReadOnly {
    override val agentIds: Optional[List[AgentId]] = zio.aws.core.internal
      .optionalFromNullable(impl.agentIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector.model.primitives.AgentId(item)
        }.toList
      )
    override val autoScalingGroups: Optional[List[AutoScalingGroup]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector.model.primitives.AutoScalingGroup(item)
          }.toList
        )
    override val ruleNames: Optional[List[RuleName]] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector.model.primitives.RuleName(item)
        }.toList
      )
    override val severities: Optional[List[zio.aws.inspector.model.Severity]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector.model.Severity.wrap(item)
          }.toList
        )
    override val rulesPackageArns: Optional[List[Arn]] = zio.aws.core.internal
      .optionalFromNullable(impl.rulesPackageArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector.model.primitives.Arn(item)
        }.toList
      )
    override val attributes
        : Optional[List[zio.aws.inspector.model.Attribute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector.model.Attribute.wrap(item)
          }.toList
        )
    override val userAttributes
        : Optional[List[zio.aws.inspector.model.Attribute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userAttributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector.model.Attribute.wrap(item)
          }.toList
        )
    override val creationTimeRange
        : Optional[zio.aws.inspector.model.TimestampRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTimeRange())
        .map(value => zio.aws.inspector.model.TimestampRange.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.FindingFilter
  ): zio.aws.inspector.model.FindingFilter.ReadOnly = new Wrapper(impl)
}
