package zio.aws.inspector.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.inspector.model.primitives.{Timestamp, AssessmentTargetName, Arn}
import scala.jdk.CollectionConverters._
final case class AssessmentTarget(
    arn: Arn,
    name: AssessmentTargetName,
    resourceGroupArn: Optional[Arn] = Optional.Absent,
    createdAt: Timestamp,
    updatedAt: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.AssessmentTarget = {
    import AssessmentTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.AssessmentTarget
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .name(AssessmentTargetName.unwrap(name): java.lang.String)
      .optionallyWith(
        resourceGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.resourceGroupArn)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .updatedAt(Timestamp.unwrap(updatedAt): Instant)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.AssessmentTarget.ReadOnly =
    zio.aws.inspector.model.AssessmentTarget.wrap(buildAwsValue())
}
object AssessmentTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.AssessmentTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.AssessmentTarget =
      zio.aws.inspector.model.AssessmentTarget(
        arn,
        name,
        resourceGroupArn.map(value => value),
        createdAt,
        updatedAt
      )
    def arn: Arn
    def name: AssessmentTargetName
    def resourceGroupArn: Optional[Arn]
    def createdAt: Timestamp
    def updatedAt: Timestamp
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getName: ZIO[Any, Nothing, AssessmentTargetName] = ZIO.succeed(name)
    def getResourceGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("resourceGroupArn", resourceGroupArn)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getUpdatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.AssessmentTarget
  ) extends zio.aws.inspector.model.AssessmentTarget.ReadOnly {
    override val arn: Arn = zio.aws.inspector.model.primitives.Arn(impl.arn())
    override val name: AssessmentTargetName =
      zio.aws.inspector.model.primitives.AssessmentTargetName(impl.name())
    override val resourceGroupArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceGroupArn())
      .map(value => zio.aws.inspector.model.primitives.Arn(value))
    override val createdAt: Timestamp =
      zio.aws.inspector.model.primitives.Timestamp(impl.createdAt())
    override val updatedAt: Timestamp =
      zio.aws.inspector.model.primitives.Timestamp(impl.updatedAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.AssessmentTarget
  ): zio.aws.inspector.model.AssessmentTarget.ReadOnly = new Wrapper(impl)
}
