package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeAssessmentTargetsRequest(
    assessmentTargetArns: Iterable[Arn]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.DescribeAssessmentTargetsRequest = {
    import DescribeAssessmentTargetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.DescribeAssessmentTargetsRequest
      .builder()
      .assessmentTargetArns(assessmentTargetArns.map { item =>
        Arn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.DescribeAssessmentTargetsRequest.ReadOnly =
    zio.aws.inspector.model.DescribeAssessmentTargetsRequest
      .wrap(buildAwsValue())
}
object DescribeAssessmentTargetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.DescribeAssessmentTargetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.DescribeAssessmentTargetsRequest =
      zio.aws.inspector.model
        .DescribeAssessmentTargetsRequest(assessmentTargetArns)
    def assessmentTargetArns: List[Arn]
    def getAssessmentTargetArns: ZIO[Any, Nothing, List[Arn]] =
      ZIO.succeed(assessmentTargetArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.DescribeAssessmentTargetsRequest
  ) extends zio.aws.inspector.model.DescribeAssessmentTargetsRequest.ReadOnly {
    override val assessmentTargetArns: List[Arn] = impl
      .assessmentTargetArns()
      .asScala
      .map { item =>
        zio.aws.inspector.model.primitives.Arn(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.DescribeAssessmentTargetsRequest
  ): zio.aws.inspector.model.DescribeAssessmentTargetsRequest.ReadOnly =
    new Wrapper(impl)
}
