package zio.aws.inspector
import zio.aws.inspector.model.DescribeAssessmentRunsResponse.ReadOnly
import software.amazon.awssdk.services.inspector.model.{
  SubscribeToEventRequest,
  DescribeRulesPackagesResponse,
  GetExclusionsPreviewRequest,
  ListAssessmentTemplatesRequest,
  GetAssessmentReportRequest,
  CreateAssessmentTargetRequest,
  UnsubscribeFromEventResponse,
  StopAssessmentRunResponse,
  RegisterCrossAccountAccessRoleResponse,
  UnsubscribeFromEventRequest,
  GetExclusionsPreviewResponse,
  DescribeResourceGroupsRequest,
  UpdateAssessmentTargetResponse,
  CreateAssessmentTemplateResponse,
  StartAssessmentRunResponse,
  DescribeRulesPackagesRequest,
  UpdateAssessmentTargetRequest,
  AddAttributesToFindingsResponse,
  DescribeAssessmentRunsRequest,
  DescribeCrossAccountAccessRoleResponse,
  ListEventSubscriptionsRequest,
  ListTagsForResourceRequest,
  CreateExclusionsPreviewRequest,
  CreateResourceGroupRequest,
  ListAssessmentRunAgentsRequest,
  GetAssessmentReportResponse,
  DescribeExclusionsRequest,
  ListAssessmentRunsRequest,
  AddAttributesToFindingsRequest,
  ListExclusionsResponse,
  ListTagsForResourceResponse,
  ListFindingsResponse,
  CreateAssessmentTargetResponse,
  GetTelemetryMetadataResponse,
  DescribeAssessmentRunsResponse,
  RemoveAttributesFromFindingsRequest,
  DeleteAssessmentTemplateRequest,
  GetTelemetryMetadataRequest,
  ListRulesPackagesResponse,
  DescribeCrossAccountAccessRoleRequest,
  ListFindingsRequest,
  ListAssessmentTargetsRequest,
  DescribeAssessmentTemplatesResponse,
  DescribeFindingsRequest,
  PreviewAgentsRequest,
  StartAssessmentRunRequest,
  RemoveAttributesFromFindingsResponse,
  DescribeAssessmentTargetsResponse,
  ListRulesPackagesRequest,
  PreviewAgentsResponse,
  DeleteAssessmentTargetRequest,
  DescribeAssessmentTargetsRequest,
  ListEventSubscriptionsResponse,
  StopAssessmentRunRequest,
  SubscribeToEventResponse,
  ListAssessmentRunAgentsResponse,
  DescribeAssessmentTemplatesRequest,
  DeleteAssessmentRunResponse,
  DeleteAssessmentTemplateResponse,
  RegisterCrossAccountAccessRoleRequest,
  ListAssessmentTargetsResponse,
  DeleteAssessmentRunRequest,
  DescribeFindingsResponse,
  CreateResourceGroupResponse,
  CreateExclusionsPreviewResponse,
  ListExclusionsRequest,
  DeleteAssessmentTargetResponse,
  SetTagsForResourceRequest,
  ListAssessmentTemplatesResponse,
  DescribeResourceGroupsResponse,
  CreateAssessmentTemplateRequest,
  SetTagsForResourceResponse,
  DescribeExclusionsResponse,
  ListAssessmentRunsResponse
}
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.inspector.{
  InspectorAsyncClientBuilder,
  InspectorAsyncClient
}
import scala.jdk.CollectionConverters._
trait Inspector extends AspectSupport[Inspector] {
  val api: InspectorAsyncClient
  def stopAssessmentRun(
      request: zio.aws.inspector.model.StopAssessmentRunRequest
  ): IO[AwsError, Unit]
  def listEventSubscriptions(
      request: zio.aws.inspector.model.ListEventSubscriptionsRequest
  ): IO[
    AwsError,
    zio.aws.inspector.model.ListEventSubscriptionsResponse.ReadOnly
  ]
  def listFindings(
      request: zio.aws.inspector.model.ListFindingsRequest
  ): IO[AwsError, zio.aws.inspector.model.ListFindingsResponse.ReadOnly]
  def updateAssessmentTarget(
      request: zio.aws.inspector.model.UpdateAssessmentTargetRequest
  ): IO[AwsError, Unit]
  def startAssessmentRun(
      request: zio.aws.inspector.model.StartAssessmentRunRequest
  ): IO[AwsError, zio.aws.inspector.model.StartAssessmentRunResponse.ReadOnly]
  def listAssessmentTemplates(
      request: zio.aws.inspector.model.ListAssessmentTemplatesRequest
  ): IO[
    AwsError,
    zio.aws.inspector.model.ListAssessmentTemplatesResponse.ReadOnly
  ]
  def createAssessmentTarget(
      request: zio.aws.inspector.model.CreateAssessmentTargetRequest
  ): IO[
    AwsError,
    zio.aws.inspector.model.CreateAssessmentTargetResponse.ReadOnly
  ]
  def describeAssessmentTargets(
      request: zio.aws.inspector.model.DescribeAssessmentTargetsRequest
  ): IO[
    AwsError,
    zio.aws.inspector.model.DescribeAssessmentTargetsResponse.ReadOnly
  ]
  def addAttributesToFindings(
      request: zio.aws.inspector.model.AddAttributesToFindingsRequest
  ): IO[
    AwsError,
    zio.aws.inspector.model.AddAttributesToFindingsResponse.ReadOnly
  ]
  def describeResourceGroups(
      request: zio.aws.inspector.model.DescribeResourceGroupsRequest
  ): IO[
    AwsError,
    zio.aws.inspector.model.DescribeResourceGroupsResponse.ReadOnly
  ]
  def createAssessmentTemplate(
      request: zio.aws.inspector.model.CreateAssessmentTemplateRequest
  ): IO[
    AwsError,
    zio.aws.inspector.model.CreateAssessmentTemplateResponse.ReadOnly
  ]
  def describeExclusions(
      request: zio.aws.inspector.model.DescribeExclusionsRequest
  ): IO[AwsError, zio.aws.inspector.model.DescribeExclusionsResponse.ReadOnly]
  def unsubscribeFromEvent(
      request: zio.aws.inspector.model.UnsubscribeFromEventRequest
  ): IO[AwsError, Unit]
  def getAssessmentReport(
      request: zio.aws.inspector.model.GetAssessmentReportRequest
  ): IO[AwsError, zio.aws.inspector.model.GetAssessmentReportResponse.ReadOnly]
  def registerCrossAccountAccessRole(
      request: zio.aws.inspector.model.RegisterCrossAccountAccessRoleRequest
  ): IO[AwsError, Unit]
  def describeFindings(
      request: zio.aws.inspector.model.DescribeFindingsRequest
  ): IO[AwsError, zio.aws.inspector.model.DescribeFindingsResponse.ReadOnly]
  def describeAssessmentTemplates(
      request: zio.aws.inspector.model.DescribeAssessmentTemplatesRequest
  ): IO[
    AwsError,
    zio.aws.inspector.model.DescribeAssessmentTemplatesResponse.ReadOnly
  ]
  def createExclusionsPreview(
      request: zio.aws.inspector.model.CreateExclusionsPreviewRequest
  ): IO[
    AwsError,
    zio.aws.inspector.model.CreateExclusionsPreviewResponse.ReadOnly
  ]
  def deleteAssessmentRun(
      request: zio.aws.inspector.model.DeleteAssessmentRunRequest
  ): IO[AwsError, Unit]
  def getTelemetryMetadata(
      request: zio.aws.inspector.model.GetTelemetryMetadataRequest
  ): IO[AwsError, zio.aws.inspector.model.GetTelemetryMetadataResponse.ReadOnly]
  def getExclusionsPreview(
      request: zio.aws.inspector.model.GetExclusionsPreviewRequest
  ): IO[AwsError, zio.aws.inspector.model.GetExclusionsPreviewResponse.ReadOnly]
  def listAssessmentRunAgents(
      request: zio.aws.inspector.model.ListAssessmentRunAgentsRequest
  ): IO[
    AwsError,
    zio.aws.inspector.model.ListAssessmentRunAgentsResponse.ReadOnly
  ]
  def previewAgents(
      request: zio.aws.inspector.model.PreviewAgentsRequest
  ): IO[AwsError, zio.aws.inspector.model.PreviewAgentsResponse.ReadOnly]
  def listAssessmentTargets(
      request: zio.aws.inspector.model.ListAssessmentTargetsRequest
  ): IO[
    AwsError,
    zio.aws.inspector.model.ListAssessmentTargetsResponse.ReadOnly
  ]
  def subscribeToEvent(
      request: zio.aws.inspector.model.SubscribeToEventRequest
  ): IO[AwsError, Unit]
  def listRulesPackages(
      request: zio.aws.inspector.model.ListRulesPackagesRequest
  ): IO[AwsError, zio.aws.inspector.model.ListRulesPackagesResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.inspector.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.inspector.model.ListTagsForResourceResponse.ReadOnly]
  def deleteAssessmentTarget(
      request: zio.aws.inspector.model.DeleteAssessmentTargetRequest
  ): IO[AwsError, Unit]
  def listAssessmentRuns(
      request: zio.aws.inspector.model.ListAssessmentRunsRequest
  ): IO[AwsError, zio.aws.inspector.model.ListAssessmentRunsResponse.ReadOnly]
  def describeAssessmentRuns(
      request: zio.aws.inspector.model.DescribeAssessmentRunsRequest
  ): IO[AwsError, ReadOnly]
  def describeCrossAccountAccessRole(): IO[
    AwsError,
    zio.aws.inspector.model.DescribeCrossAccountAccessRoleResponse.ReadOnly
  ]
  def removeAttributesFromFindings(
      request: zio.aws.inspector.model.RemoveAttributesFromFindingsRequest
  ): IO[
    AwsError,
    zio.aws.inspector.model.RemoveAttributesFromFindingsResponse.ReadOnly
  ]
  def deleteAssessmentTemplate(
      request: zio.aws.inspector.model.DeleteAssessmentTemplateRequest
  ): IO[AwsError, Unit]
  def createResourceGroup(
      request: zio.aws.inspector.model.CreateResourceGroupRequest
  ): IO[AwsError, zio.aws.inspector.model.CreateResourceGroupResponse.ReadOnly]
  def setTagsForResource(
      request: zio.aws.inspector.model.SetTagsForResourceRequest
  ): IO[AwsError, Unit]
  def describeRulesPackages(
      request: zio.aws.inspector.model.DescribeRulesPackagesRequest
  ): IO[
    AwsError,
    zio.aws.inspector.model.DescribeRulesPackagesResponse.ReadOnly
  ]
  def listExclusions(
      request: zio.aws.inspector.model.ListExclusionsRequest
  ): IO[AwsError, zio.aws.inspector.model.ListExclusionsResponse.ReadOnly]
}
object Inspector {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Inspector] = customized(
    identity
  )
  def customized(
      customization: InspectorAsyncClientBuilder => InspectorAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Inspector] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: InspectorAsyncClientBuilder => InspectorAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Inspector] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = InspectorAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[InspectorAsyncClient, InspectorAsyncClientBuilder](builder);
    b1 <- awsConfig
      .configureHttpClient[InspectorAsyncClient, InspectorAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new InspectorImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class InspectorImpl[R](
      override val api: InspectorAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Inspector
      with AwsServiceBase[R] {
    override val serviceName: String = "Inspector"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): InspectorImpl[R1] = new InspectorImpl(api, newAspect, r)
    def stopAssessmentRun(
        request: zio.aws.inspector.model.StopAssessmentRunRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[StopAssessmentRunRequest, StopAssessmentRunResponse](
        "stopAssessmentRun",
        api.stopAssessmentRun
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def listEventSubscriptions(
        request: zio.aws.inspector.model.ListEventSubscriptionsRequest
    ): IO[
      AwsError,
      zio.aws.inspector.model.ListEventSubscriptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListEventSubscriptionsRequest,
      ListEventSubscriptionsResponse
    ]("listEventSubscriptions", api.listEventSubscriptions)(
      request.buildAwsValue()
    ).map(zio.aws.inspector.model.ListEventSubscriptionsResponse.wrap)
      .provideEnvironment(r)
    def listFindings(
        request: zio.aws.inspector.model.ListFindingsRequest
    ): IO[AwsError, zio.aws.inspector.model.ListFindingsResponse.ReadOnly] =
      asyncRequestResponse[ListFindingsRequest, ListFindingsResponse](
        "listFindings",
        api.listFindings
      )(request.buildAwsValue())
        .map(zio.aws.inspector.model.ListFindingsResponse.wrap)
        .provideEnvironment(r)
    def updateAssessmentTarget(
        request: zio.aws.inspector.model.UpdateAssessmentTargetRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      UpdateAssessmentTargetRequest,
      UpdateAssessmentTargetResponse
    ]("updateAssessmentTarget", api.updateAssessmentTarget)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def startAssessmentRun(
        request: zio.aws.inspector.model.StartAssessmentRunRequest
    ): IO[
      AwsError,
      zio.aws.inspector.model.StartAssessmentRunResponse.ReadOnly
    ] = asyncRequestResponse[
      StartAssessmentRunRequest,
      StartAssessmentRunResponse
    ]("startAssessmentRun", api.startAssessmentRun)(request.buildAwsValue())
      .map(zio.aws.inspector.model.StartAssessmentRunResponse.wrap)
      .provideEnvironment(r)
    def listAssessmentTemplates(
        request: zio.aws.inspector.model.ListAssessmentTemplatesRequest
    ): IO[
      AwsError,
      zio.aws.inspector.model.ListAssessmentTemplatesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListAssessmentTemplatesRequest,
      ListAssessmentTemplatesResponse
    ]("listAssessmentTemplates", api.listAssessmentTemplates)(
      request.buildAwsValue()
    ).map(zio.aws.inspector.model.ListAssessmentTemplatesResponse.wrap)
      .provideEnvironment(r)
    def createAssessmentTarget(
        request: zio.aws.inspector.model.CreateAssessmentTargetRequest
    ): IO[
      AwsError,
      zio.aws.inspector.model.CreateAssessmentTargetResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateAssessmentTargetRequest,
      CreateAssessmentTargetResponse
    ]("createAssessmentTarget", api.createAssessmentTarget)(
      request.buildAwsValue()
    ).map(zio.aws.inspector.model.CreateAssessmentTargetResponse.wrap)
      .provideEnvironment(r)
    def describeAssessmentTargets(
        request: zio.aws.inspector.model.DescribeAssessmentTargetsRequest
    ): IO[
      AwsError,
      zio.aws.inspector.model.DescribeAssessmentTargetsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeAssessmentTargetsRequest,
      DescribeAssessmentTargetsResponse
    ]("describeAssessmentTargets", api.describeAssessmentTargets)(
      request.buildAwsValue()
    ).map(zio.aws.inspector.model.DescribeAssessmentTargetsResponse.wrap)
      .provideEnvironment(r)
    def addAttributesToFindings(
        request: zio.aws.inspector.model.AddAttributesToFindingsRequest
    ): IO[
      AwsError,
      zio.aws.inspector.model.AddAttributesToFindingsResponse.ReadOnly
    ] = asyncRequestResponse[
      AddAttributesToFindingsRequest,
      AddAttributesToFindingsResponse
    ]("addAttributesToFindings", api.addAttributesToFindings)(
      request.buildAwsValue()
    ).map(zio.aws.inspector.model.AddAttributesToFindingsResponse.wrap)
      .provideEnvironment(r)
    def describeResourceGroups(
        request: zio.aws.inspector.model.DescribeResourceGroupsRequest
    ): IO[
      AwsError,
      zio.aws.inspector.model.DescribeResourceGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeResourceGroupsRequest,
      DescribeResourceGroupsResponse
    ]("describeResourceGroups", api.describeResourceGroups)(
      request.buildAwsValue()
    ).map(zio.aws.inspector.model.DescribeResourceGroupsResponse.wrap)
      .provideEnvironment(r)
    def createAssessmentTemplate(
        request: zio.aws.inspector.model.CreateAssessmentTemplateRequest
    ): IO[
      AwsError,
      zio.aws.inspector.model.CreateAssessmentTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateAssessmentTemplateRequest,
      CreateAssessmentTemplateResponse
    ]("createAssessmentTemplate", api.createAssessmentTemplate)(
      request.buildAwsValue()
    ).map(zio.aws.inspector.model.CreateAssessmentTemplateResponse.wrap)
      .provideEnvironment(r)
    def describeExclusions(
        request: zio.aws.inspector.model.DescribeExclusionsRequest
    ): IO[
      AwsError,
      zio.aws.inspector.model.DescribeExclusionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeExclusionsRequest,
      DescribeExclusionsResponse
    ]("describeExclusions", api.describeExclusions)(request.buildAwsValue())
      .map(zio.aws.inspector.model.DescribeExclusionsResponse.wrap)
      .provideEnvironment(r)
    def unsubscribeFromEvent(
        request: zio.aws.inspector.model.UnsubscribeFromEventRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      UnsubscribeFromEventRequest,
      UnsubscribeFromEventResponse
    ]("unsubscribeFromEvent", api.unsubscribeFromEvent)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getAssessmentReport(
        request: zio.aws.inspector.model.GetAssessmentReportRequest
    ): IO[
      AwsError,
      zio.aws.inspector.model.GetAssessmentReportResponse.ReadOnly
    ] = asyncRequestResponse[
      GetAssessmentReportRequest,
      GetAssessmentReportResponse
    ]("getAssessmentReport", api.getAssessmentReport)(request.buildAwsValue())
      .map(zio.aws.inspector.model.GetAssessmentReportResponse.wrap)
      .provideEnvironment(r)
    def registerCrossAccountAccessRole(
        request: zio.aws.inspector.model.RegisterCrossAccountAccessRoleRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      RegisterCrossAccountAccessRoleRequest,
      RegisterCrossAccountAccessRoleResponse
    ]("registerCrossAccountAccessRole", api.registerCrossAccountAccessRole)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeFindings(
        request: zio.aws.inspector.model.DescribeFindingsRequest
    ): IO[AwsError, zio.aws.inspector.model.DescribeFindingsResponse.ReadOnly] =
      asyncRequestResponse[DescribeFindingsRequest, DescribeFindingsResponse](
        "describeFindings",
        api.describeFindings
      )(request.buildAwsValue())
        .map(zio.aws.inspector.model.DescribeFindingsResponse.wrap)
        .provideEnvironment(r)
    def describeAssessmentTemplates(
        request: zio.aws.inspector.model.DescribeAssessmentTemplatesRequest
    ): IO[
      AwsError,
      zio.aws.inspector.model.DescribeAssessmentTemplatesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeAssessmentTemplatesRequest,
      DescribeAssessmentTemplatesResponse
    ]("describeAssessmentTemplates", api.describeAssessmentTemplates)(
      request.buildAwsValue()
    ).map(zio.aws.inspector.model.DescribeAssessmentTemplatesResponse.wrap)
      .provideEnvironment(r)
    def createExclusionsPreview(
        request: zio.aws.inspector.model.CreateExclusionsPreviewRequest
    ): IO[
      AwsError,
      zio.aws.inspector.model.CreateExclusionsPreviewResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateExclusionsPreviewRequest,
      CreateExclusionsPreviewResponse
    ]("createExclusionsPreview", api.createExclusionsPreview)(
      request.buildAwsValue()
    ).map(zio.aws.inspector.model.CreateExclusionsPreviewResponse.wrap)
      .provideEnvironment(r)
    def deleteAssessmentRun(
        request: zio.aws.inspector.model.DeleteAssessmentRunRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteAssessmentRunRequest,
      DeleteAssessmentRunResponse
    ]("deleteAssessmentRun", api.deleteAssessmentRun)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getTelemetryMetadata(
        request: zio.aws.inspector.model.GetTelemetryMetadataRequest
    ): IO[
      AwsError,
      zio.aws.inspector.model.GetTelemetryMetadataResponse.ReadOnly
    ] = asyncRequestResponse[
      GetTelemetryMetadataRequest,
      GetTelemetryMetadataResponse
    ]("getTelemetryMetadata", api.getTelemetryMetadata)(request.buildAwsValue())
      .map(zio.aws.inspector.model.GetTelemetryMetadataResponse.wrap)
      .provideEnvironment(r)
    def getExclusionsPreview(
        request: zio.aws.inspector.model.GetExclusionsPreviewRequest
    ): IO[
      AwsError,
      zio.aws.inspector.model.GetExclusionsPreviewResponse.ReadOnly
    ] = asyncRequestResponse[
      GetExclusionsPreviewRequest,
      GetExclusionsPreviewResponse
    ]("getExclusionsPreview", api.getExclusionsPreview)(request.buildAwsValue())
      .map(zio.aws.inspector.model.GetExclusionsPreviewResponse.wrap)
      .provideEnvironment(r)
    def listAssessmentRunAgents(
        request: zio.aws.inspector.model.ListAssessmentRunAgentsRequest
    ): IO[
      AwsError,
      zio.aws.inspector.model.ListAssessmentRunAgentsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListAssessmentRunAgentsRequest,
      ListAssessmentRunAgentsResponse
    ]("listAssessmentRunAgents", api.listAssessmentRunAgents)(
      request.buildAwsValue()
    ).map(zio.aws.inspector.model.ListAssessmentRunAgentsResponse.wrap)
      .provideEnvironment(r)
    def previewAgents(
        request: zio.aws.inspector.model.PreviewAgentsRequest
    ): IO[AwsError, zio.aws.inspector.model.PreviewAgentsResponse.ReadOnly] =
      asyncRequestResponse[PreviewAgentsRequest, PreviewAgentsResponse](
        "previewAgents",
        api.previewAgents
      )(request.buildAwsValue())
        .map(zio.aws.inspector.model.PreviewAgentsResponse.wrap)
        .provideEnvironment(r)
    def listAssessmentTargets(
        request: zio.aws.inspector.model.ListAssessmentTargetsRequest
    ): IO[
      AwsError,
      zio.aws.inspector.model.ListAssessmentTargetsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListAssessmentTargetsRequest,
      ListAssessmentTargetsResponse
    ]("listAssessmentTargets", api.listAssessmentTargets)(
      request.buildAwsValue()
    ).map(zio.aws.inspector.model.ListAssessmentTargetsResponse.wrap)
      .provideEnvironment(r)
    def subscribeToEvent(
        request: zio.aws.inspector.model.SubscribeToEventRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[SubscribeToEventRequest, SubscribeToEventResponse](
        "subscribeToEvent",
        api.subscribeToEvent
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def listRulesPackages(
        request: zio.aws.inspector.model.ListRulesPackagesRequest
    ): IO[
      AwsError,
      zio.aws.inspector.model.ListRulesPackagesResponse.ReadOnly
    ] =
      asyncRequestResponse[ListRulesPackagesRequest, ListRulesPackagesResponse](
        "listRulesPackages",
        api.listRulesPackages
      )(request.buildAwsValue())
        .map(zio.aws.inspector.model.ListRulesPackagesResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.inspector.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.inspector.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.inspector.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def deleteAssessmentTarget(
        request: zio.aws.inspector.model.DeleteAssessmentTargetRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteAssessmentTargetRequest,
      DeleteAssessmentTargetResponse
    ]("deleteAssessmentTarget", api.deleteAssessmentTarget)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listAssessmentRuns(
        request: zio.aws.inspector.model.ListAssessmentRunsRequest
    ): IO[
      AwsError,
      zio.aws.inspector.model.ListAssessmentRunsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListAssessmentRunsRequest,
      ListAssessmentRunsResponse
    ]("listAssessmentRuns", api.listAssessmentRuns)(request.buildAwsValue())
      .map(zio.aws.inspector.model.ListAssessmentRunsResponse.wrap)
      .provideEnvironment(r)
    def describeAssessmentRuns(
        request: zio.aws.inspector.model.DescribeAssessmentRunsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      DescribeAssessmentRunsRequest,
      DescribeAssessmentRunsResponse
    ]("describeAssessmentRuns", api.describeAssessmentRuns)(
      request.buildAwsValue()
    ).map(zio.aws.inspector.model.DescribeAssessmentRunsResponse.wrap)
      .provideEnvironment(r)
    def describeCrossAccountAccessRole(): IO[
      AwsError,
      zio.aws.inspector.model.DescribeCrossAccountAccessRoleResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeCrossAccountAccessRoleRequest,
      DescribeCrossAccountAccessRoleResponse
    ]("describeCrossAccountAccessRole", api.describeCrossAccountAccessRole)(
      DescribeCrossAccountAccessRoleRequest.builder().build()
    ).map(zio.aws.inspector.model.DescribeCrossAccountAccessRoleResponse.wrap)
      .provideEnvironment(r)
    def removeAttributesFromFindings(
        request: zio.aws.inspector.model.RemoveAttributesFromFindingsRequest
    ): IO[
      AwsError,
      zio.aws.inspector.model.RemoveAttributesFromFindingsResponse.ReadOnly
    ] = asyncRequestResponse[
      RemoveAttributesFromFindingsRequest,
      RemoveAttributesFromFindingsResponse
    ]("removeAttributesFromFindings", api.removeAttributesFromFindings)(
      request.buildAwsValue()
    ).map(zio.aws.inspector.model.RemoveAttributesFromFindingsResponse.wrap)
      .provideEnvironment(r)
    def deleteAssessmentTemplate(
        request: zio.aws.inspector.model.DeleteAssessmentTemplateRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteAssessmentTemplateRequest,
      DeleteAssessmentTemplateResponse
    ]("deleteAssessmentTemplate", api.deleteAssessmentTemplate)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createResourceGroup(
        request: zio.aws.inspector.model.CreateResourceGroupRequest
    ): IO[
      AwsError,
      zio.aws.inspector.model.CreateResourceGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateResourceGroupRequest,
      CreateResourceGroupResponse
    ]("createResourceGroup", api.createResourceGroup)(request.buildAwsValue())
      .map(zio.aws.inspector.model.CreateResourceGroupResponse.wrap)
      .provideEnvironment(r)
    def setTagsForResource(
        request: zio.aws.inspector.model.SetTagsForResourceRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      SetTagsForResourceRequest,
      SetTagsForResourceResponse
    ]("setTagsForResource", api.setTagsForResource)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeRulesPackages(
        request: zio.aws.inspector.model.DescribeRulesPackagesRequest
    ): IO[
      AwsError,
      zio.aws.inspector.model.DescribeRulesPackagesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeRulesPackagesRequest,
      DescribeRulesPackagesResponse
    ]("describeRulesPackages", api.describeRulesPackages)(
      request.buildAwsValue()
    ).map(zio.aws.inspector.model.DescribeRulesPackagesResponse.wrap)
      .provideEnvironment(r)
    def listExclusions(
        request: zio.aws.inspector.model.ListExclusionsRequest
    ): IO[AwsError, zio.aws.inspector.model.ListExclusionsResponse.ReadOnly] =
      asyncRequestResponse[ListExclusionsRequest, ListExclusionsResponse](
        "listExclusions",
        api.listExclusions
      )(request.buildAwsValue())
        .map(zio.aws.inspector.model.ListExclusionsResponse.wrap)
        .provideEnvironment(r)
  }
  def stopAssessmentRun(
      request: zio.aws.inspector.model.StopAssessmentRunRequest
  ): ZIO[zio.aws.inspector.Inspector, AwsError, Unit] =
    ZIO.serviceWithZIO(_.stopAssessmentRun(request))
  def listEventSubscriptions(
      request: zio.aws.inspector.model.ListEventSubscriptionsRequest
  ): ZIO[
    zio.aws.inspector.Inspector,
    AwsError,
    zio.aws.inspector.model.ListEventSubscriptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEventSubscriptions(request))
  def listFindings(request: zio.aws.inspector.model.ListFindingsRequest): ZIO[
    zio.aws.inspector.Inspector,
    AwsError,
    zio.aws.inspector.model.ListFindingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFindings(request))
  def updateAssessmentTarget(
      request: zio.aws.inspector.model.UpdateAssessmentTargetRequest
  ): ZIO[zio.aws.inspector.Inspector, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateAssessmentTarget(request))
  def startAssessmentRun(
      request: zio.aws.inspector.model.StartAssessmentRunRequest
  ): ZIO[
    zio.aws.inspector.Inspector,
    AwsError,
    zio.aws.inspector.model.StartAssessmentRunResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startAssessmentRun(request))
  def listAssessmentTemplates(
      request: zio.aws.inspector.model.ListAssessmentTemplatesRequest
  ): ZIO[
    zio.aws.inspector.Inspector,
    AwsError,
    zio.aws.inspector.model.ListAssessmentTemplatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAssessmentTemplates(request))
  def createAssessmentTarget(
      request: zio.aws.inspector.model.CreateAssessmentTargetRequest
  ): ZIO[
    zio.aws.inspector.Inspector,
    AwsError,
    zio.aws.inspector.model.CreateAssessmentTargetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAssessmentTarget(request))
  def describeAssessmentTargets(
      request: zio.aws.inspector.model.DescribeAssessmentTargetsRequest
  ): ZIO[
    zio.aws.inspector.Inspector,
    AwsError,
    zio.aws.inspector.model.DescribeAssessmentTargetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAssessmentTargets(request))
  def addAttributesToFindings(
      request: zio.aws.inspector.model.AddAttributesToFindingsRequest
  ): ZIO[
    zio.aws.inspector.Inspector,
    AwsError,
    zio.aws.inspector.model.AddAttributesToFindingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addAttributesToFindings(request))
  def describeResourceGroups(
      request: zio.aws.inspector.model.DescribeResourceGroupsRequest
  ): ZIO[
    zio.aws.inspector.Inspector,
    AwsError,
    zio.aws.inspector.model.DescribeResourceGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeResourceGroups(request))
  def createAssessmentTemplate(
      request: zio.aws.inspector.model.CreateAssessmentTemplateRequest
  ): ZIO[
    zio.aws.inspector.Inspector,
    AwsError,
    zio.aws.inspector.model.CreateAssessmentTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAssessmentTemplate(request))
  def describeExclusions(
      request: zio.aws.inspector.model.DescribeExclusionsRequest
  ): ZIO[
    zio.aws.inspector.Inspector,
    AwsError,
    zio.aws.inspector.model.DescribeExclusionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeExclusions(request))
  def unsubscribeFromEvent(
      request: zio.aws.inspector.model.UnsubscribeFromEventRequest
  ): ZIO[zio.aws.inspector.Inspector, AwsError, Unit] =
    ZIO.serviceWithZIO(_.unsubscribeFromEvent(request))
  def getAssessmentReport(
      request: zio.aws.inspector.model.GetAssessmentReportRequest
  ): ZIO[
    zio.aws.inspector.Inspector,
    AwsError,
    zio.aws.inspector.model.GetAssessmentReportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAssessmentReport(request))
  def registerCrossAccountAccessRole(
      request: zio.aws.inspector.model.RegisterCrossAccountAccessRoleRequest
  ): ZIO[zio.aws.inspector.Inspector, AwsError, Unit] =
    ZIO.serviceWithZIO(_.registerCrossAccountAccessRole(request))
  def describeFindings(
      request: zio.aws.inspector.model.DescribeFindingsRequest
  ): ZIO[
    zio.aws.inspector.Inspector,
    AwsError,
    zio.aws.inspector.model.DescribeFindingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFindings(request))
  def describeAssessmentTemplates(
      request: zio.aws.inspector.model.DescribeAssessmentTemplatesRequest
  ): ZIO[
    zio.aws.inspector.Inspector,
    AwsError,
    zio.aws.inspector.model.DescribeAssessmentTemplatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAssessmentTemplates(request))
  def createExclusionsPreview(
      request: zio.aws.inspector.model.CreateExclusionsPreviewRequest
  ): ZIO[
    zio.aws.inspector.Inspector,
    AwsError,
    zio.aws.inspector.model.CreateExclusionsPreviewResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createExclusionsPreview(request))
  def deleteAssessmentRun(
      request: zio.aws.inspector.model.DeleteAssessmentRunRequest
  ): ZIO[zio.aws.inspector.Inspector, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAssessmentRun(request))
  def getTelemetryMetadata(
      request: zio.aws.inspector.model.GetTelemetryMetadataRequest
  ): ZIO[
    zio.aws.inspector.Inspector,
    AwsError,
    zio.aws.inspector.model.GetTelemetryMetadataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTelemetryMetadata(request))
  def getExclusionsPreview(
      request: zio.aws.inspector.model.GetExclusionsPreviewRequest
  ): ZIO[
    zio.aws.inspector.Inspector,
    AwsError,
    zio.aws.inspector.model.GetExclusionsPreviewResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getExclusionsPreview(request))
  def listAssessmentRunAgents(
      request: zio.aws.inspector.model.ListAssessmentRunAgentsRequest
  ): ZIO[
    zio.aws.inspector.Inspector,
    AwsError,
    zio.aws.inspector.model.ListAssessmentRunAgentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAssessmentRunAgents(request))
  def previewAgents(request: zio.aws.inspector.model.PreviewAgentsRequest): ZIO[
    zio.aws.inspector.Inspector,
    AwsError,
    zio.aws.inspector.model.PreviewAgentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.previewAgents(request))
  def listAssessmentTargets(
      request: zio.aws.inspector.model.ListAssessmentTargetsRequest
  ): ZIO[
    zio.aws.inspector.Inspector,
    AwsError,
    zio.aws.inspector.model.ListAssessmentTargetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAssessmentTargets(request))
  def subscribeToEvent(
      request: zio.aws.inspector.model.SubscribeToEventRequest
  ): ZIO[zio.aws.inspector.Inspector, AwsError, Unit] =
    ZIO.serviceWithZIO(_.subscribeToEvent(request))
  def listRulesPackages(
      request: zio.aws.inspector.model.ListRulesPackagesRequest
  ): ZIO[
    zio.aws.inspector.Inspector,
    AwsError,
    zio.aws.inspector.model.ListRulesPackagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRulesPackages(request))
  def listTagsForResource(
      request: zio.aws.inspector.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.inspector.Inspector,
    AwsError,
    zio.aws.inspector.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def deleteAssessmentTarget(
      request: zio.aws.inspector.model.DeleteAssessmentTargetRequest
  ): ZIO[zio.aws.inspector.Inspector, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAssessmentTarget(request))
  def listAssessmentRuns(
      request: zio.aws.inspector.model.ListAssessmentRunsRequest
  ): ZIO[
    zio.aws.inspector.Inspector,
    AwsError,
    zio.aws.inspector.model.ListAssessmentRunsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAssessmentRuns(request))
  def describeAssessmentRuns(
      request: zio.aws.inspector.model.DescribeAssessmentRunsRequest
  ): ZIO[zio.aws.inspector.Inspector, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.describeAssessmentRuns(request))
  def describeCrossAccountAccessRole(): ZIO[
    zio.aws.inspector.Inspector,
    AwsError,
    zio.aws.inspector.model.DescribeCrossAccountAccessRoleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCrossAccountAccessRole())
  def removeAttributesFromFindings(
      request: zio.aws.inspector.model.RemoveAttributesFromFindingsRequest
  ): ZIO[
    zio.aws.inspector.Inspector,
    AwsError,
    zio.aws.inspector.model.RemoveAttributesFromFindingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeAttributesFromFindings(request))
  def deleteAssessmentTemplate(
      request: zio.aws.inspector.model.DeleteAssessmentTemplateRequest
  ): ZIO[zio.aws.inspector.Inspector, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAssessmentTemplate(request))
  def createResourceGroup(
      request: zio.aws.inspector.model.CreateResourceGroupRequest
  ): ZIO[
    zio.aws.inspector.Inspector,
    AwsError,
    zio.aws.inspector.model.CreateResourceGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createResourceGroup(request))
  def setTagsForResource(
      request: zio.aws.inspector.model.SetTagsForResourceRequest
  ): ZIO[zio.aws.inspector.Inspector, AwsError, Unit] =
    ZIO.serviceWithZIO(_.setTagsForResource(request))
  def describeRulesPackages(
      request: zio.aws.inspector.model.DescribeRulesPackagesRequest
  ): ZIO[
    zio.aws.inspector.Inspector,
    AwsError,
    zio.aws.inspector.model.DescribeRulesPackagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRulesPackages(request))
  def listExclusions(
      request: zio.aws.inspector.model.ListExclusionsRequest
  ): ZIO[
    zio.aws.inspector.Inspector,
    AwsError,
    zio.aws.inspector.model.ListExclusionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listExclusions(request))
}
