package zio.aws.inspector.model
import scala.jdk.CollectionConverters._
sealed trait ScopeType {
  def unwrap: software.amazon.awssdk.services.inspector.model.ScopeType
}
object ScopeType {
  def wrap(
      value: software.amazon.awssdk.services.inspector.model.ScopeType
  ): zio.aws.inspector.model.ScopeType = value match {
    case software.amazon.awssdk.services.inspector.model.ScopeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector.model.ScopeType.INSTANCE_ID =>
      val r = INSTANCE_ID
      r
    case software.amazon.awssdk.services.inspector.model.ScopeType.RULES_PACKAGE_ARN =>
      val r = RULES_PACKAGE_ARN
      r
  }
  case object unknownToSdkVersion extends zio.aws.inspector.model.ScopeType {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.ScopeType =
      software.amazon.awssdk.services.inspector.model.ScopeType.UNKNOWN_TO_SDK_VERSION
  }
  case object INSTANCE_ID extends zio.aws.inspector.model.ScopeType {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.ScopeType =
      software.amazon.awssdk.services.inspector.model.ScopeType.INSTANCE_ID
  }
  case object RULES_PACKAGE_ARN extends zio.aws.inspector.model.ScopeType {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.ScopeType =
      software.amazon.awssdk.services.inspector.model.ScopeType.RULES_PACKAGE_ARN
  }
}
