package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeAssessmentTemplatesResponse(
    assessmentTemplates: Iterable[zio.aws.inspector.model.AssessmentTemplate],
    failedItems: Map[Arn, zio.aws.inspector.model.FailedItemDetails]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.DescribeAssessmentTemplatesResponse = {
    import DescribeAssessmentTemplatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.DescribeAssessmentTemplatesResponse
      .builder()
      .assessmentTemplates(assessmentTemplates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .failedItems(
        failedItems
          .map({ case (key, value) =>
            (Arn.unwrap(key): java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.DescribeAssessmentTemplatesResponse.ReadOnly =
    zio.aws.inspector.model.DescribeAssessmentTemplatesResponse
      .wrap(buildAwsValue())
}
object DescribeAssessmentTemplatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.DescribeAssessmentTemplatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector.model.DescribeAssessmentTemplatesResponse =
      zio.aws.inspector.model.DescribeAssessmentTemplatesResponse(
        assessmentTemplates.map { item =>
          item.asEditable
        },
        failedItems.map({ case (key, value) =>
          key -> value.asEditable
        })
      )
    def assessmentTemplates
        : List[zio.aws.inspector.model.AssessmentTemplate.ReadOnly]
    def failedItems
        : Map[Arn, zio.aws.inspector.model.FailedItemDetails.ReadOnly]
    def getAssessmentTemplates: ZIO[Any, Nothing, List[
      zio.aws.inspector.model.AssessmentTemplate.ReadOnly
    ]] = ZIO.succeed(assessmentTemplates)
    def getFailedItems: ZIO[Any, Nothing, Map[
      Arn,
      zio.aws.inspector.model.FailedItemDetails.ReadOnly
    ]] = ZIO.succeed(failedItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.DescribeAssessmentTemplatesResponse
  ) extends zio.aws.inspector.model.DescribeAssessmentTemplatesResponse.ReadOnly {
    override val assessmentTemplates
        : List[zio.aws.inspector.model.AssessmentTemplate.ReadOnly] = impl
      .assessmentTemplates()
      .asScala
      .map { item =>
        zio.aws.inspector.model.AssessmentTemplate.wrap(item)
      }
      .toList
    override val failedItems
        : Map[Arn, zio.aws.inspector.model.FailedItemDetails.ReadOnly] = impl
      .failedItems()
      .asScala
      .map({ case (key, value) =>
        zio.aws.inspector.model.primitives
          .Arn(key) -> zio.aws.inspector.model.FailedItemDetails.wrap(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.DescribeAssessmentTemplatesResponse
  ): zio.aws.inspector.model.DescribeAssessmentTemplatesResponse.ReadOnly =
    new Wrapper(impl)
}
