package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.UUID
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateExclusionsPreviewResponse(previewToken: UUID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.CreateExclusionsPreviewResponse = {
    import CreateExclusionsPreviewResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.CreateExclusionsPreviewResponse
      .builder()
      .previewToken(UUID.unwrap(previewToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.CreateExclusionsPreviewResponse.ReadOnly =
    zio.aws.inspector.model.CreateExclusionsPreviewResponse
      .wrap(buildAwsValue())
}
object CreateExclusionsPreviewResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.CreateExclusionsPreviewResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.CreateExclusionsPreviewResponse =
      zio.aws.inspector.model.CreateExclusionsPreviewResponse(previewToken)
    def previewToken: UUID
    def getPreviewToken: ZIO[Any, Nothing, UUID] = ZIO.succeed(previewToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.CreateExclusionsPreviewResponse
  ) extends zio.aws.inspector.model.CreateExclusionsPreviewResponse.ReadOnly {
    override val previewToken: UUID =
      zio.aws.inspector.model.primitives.UUID(impl.previewToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.CreateExclusionsPreviewResponse
  ): zio.aws.inspector.model.CreateExclusionsPreviewResponse.ReadOnly =
    new Wrapper(impl)
}
