package zio.aws.inspector.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.inspector.model.primitives.AssessmentRunDuration
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DurationRange(
    minSeconds: Optional[AssessmentRunDuration] = Optional.Absent,
    maxSeconds: Optional[AssessmentRunDuration] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.DurationRange = {
    import DurationRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.DurationRange
      .builder()
      .optionallyWith(
        minSeconds.map(value => AssessmentRunDuration.unwrap(value): Integer)
      )(_.minSeconds)
      .optionallyWith(
        maxSeconds.map(value => AssessmentRunDuration.unwrap(value): Integer)
      )(_.maxSeconds)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.DurationRange.ReadOnly =
    zio.aws.inspector.model.DurationRange.wrap(buildAwsValue())
}
object DurationRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.DurationRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.DurationRange =
      zio.aws.inspector.model.DurationRange(
        minSeconds.map(value => value),
        maxSeconds.map(value => value)
      )
    def minSeconds: Optional[AssessmentRunDuration]
    def maxSeconds: Optional[AssessmentRunDuration]
    def getMinSeconds: ZIO[Any, AwsError, AssessmentRunDuration] =
      AwsError.unwrapOptionField("minSeconds", minSeconds)
    def getMaxSeconds: ZIO[Any, AwsError, AssessmentRunDuration] =
      AwsError.unwrapOptionField("maxSeconds", maxSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.DurationRange
  ) extends zio.aws.inspector.model.DurationRange.ReadOnly {
    override val minSeconds: Optional[AssessmentRunDuration] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minSeconds())
        .map(value =>
          zio.aws.inspector.model.primitives.AssessmentRunDuration(value)
        )
    override val maxSeconds: Optional[AssessmentRunDuration] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxSeconds())
        .map(value =>
          zio.aws.inspector.model.primitives.AssessmentRunDuration(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.DurationRange
  ): zio.aws.inspector.model.DurationRange.ReadOnly = new Wrapper(impl)
}
