package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.MessageType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TelemetryMetadata(
    messageType: MessageType,
    count: Long,
    dataSize: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.TelemetryMetadata = {
    import TelemetryMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.TelemetryMetadata
      .builder()
      .messageType(MessageType.unwrap(messageType): java.lang.String)
      .count(count: java.lang.Long)
      .optionallyWith(dataSize.map(value => value: java.lang.Long))(_.dataSize)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.TelemetryMetadata.ReadOnly =
    zio.aws.inspector.model.TelemetryMetadata.wrap(buildAwsValue())
}
object TelemetryMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.TelemetryMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.TelemetryMetadata =
      zio.aws.inspector.model
        .TelemetryMetadata(messageType, count, dataSize.map(value => value))
    def messageType: MessageType
    def count: Long
    def dataSize: Optional[Long]
    def getMessageType: ZIO[Any, Nothing, MessageType] =
      ZIO.succeed(messageType)
    def getCount: ZIO[Any, Nothing, Long] = ZIO.succeed(count)
    def getDataSize: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("dataSize", dataSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.TelemetryMetadata
  ) extends zio.aws.inspector.model.TelemetryMetadata.ReadOnly {
    override val messageType: MessageType =
      zio.aws.inspector.model.primitives.MessageType(impl.messageType())
    override val count: Long = impl.count(): Long
    override val dataSize: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSize())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.TelemetryMetadata
  ): zio.aws.inspector.model.TelemetryMetadata.ReadOnly = new Wrapper(impl)
}
