package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeResourceGroupsRequest(
    resourceGroupArns: Iterable[Arn]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.DescribeResourceGroupsRequest = {
    import DescribeResourceGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.DescribeResourceGroupsRequest
      .builder()
      .resourceGroupArns(resourceGroupArns.map { item =>
        Arn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.DescribeResourceGroupsRequest.ReadOnly =
    zio.aws.inspector.model.DescribeResourceGroupsRequest.wrap(buildAwsValue())
}
object DescribeResourceGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.DescribeResourceGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.DescribeResourceGroupsRequest =
      zio.aws.inspector.model.DescribeResourceGroupsRequest(resourceGroupArns)
    def resourceGroupArns: List[Arn]
    def getResourceGroupArns: ZIO[Any, Nothing, List[Arn]] =
      ZIO.succeed(resourceGroupArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.DescribeResourceGroupsRequest
  ) extends zio.aws.inspector.model.DescribeResourceGroupsRequest.ReadOnly {
    override val resourceGroupArns: List[Arn] = impl
      .resourceGroupArns()
      .asScala
      .map { item =>
        zio.aws.inspector.model.primitives.Arn(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.DescribeResourceGroupsRequest
  ): zio.aws.inspector.model.DescribeResourceGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
