package zio.aws.inspector.model
import scala.jdk.CollectionConverters._
sealed trait ReportFileFormat {
  def unwrap: software.amazon.awssdk.services.inspector.model.ReportFileFormat
}
object ReportFileFormat {
  def wrap(
      value: software.amazon.awssdk.services.inspector.model.ReportFileFormat
  ): zio.aws.inspector.model.ReportFileFormat = value match {
    case software.amazon.awssdk.services.inspector.model.ReportFileFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector.model.ReportFileFormat.HTML =>
      val r = HTML
      r
    case software.amazon.awssdk.services.inspector.model.ReportFileFormat.PDF =>
      val r = PDF
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector.model.ReportFileFormat {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.ReportFileFormat =
      software.amazon.awssdk.services.inspector.model.ReportFileFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object HTML extends zio.aws.inspector.model.ReportFileFormat {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.ReportFileFormat =
      software.amazon.awssdk.services.inspector.model.ReportFileFormat.HTML
  }
  case object PDF extends zio.aws.inspector.model.ReportFileFormat {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.ReportFileFormat =
      software.amazon.awssdk.services.inspector.model.ReportFileFormat.PDF
  }
}
