package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AddAttributesToFindingsRequest(
    findingArns: Iterable[Arn],
    attributes: Iterable[zio.aws.inspector.model.Attribute]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.AddAttributesToFindingsRequest = {
    import AddAttributesToFindingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.AddAttributesToFindingsRequest
      .builder()
      .findingArns(findingArns.map { item =>
        Arn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .attributes(attributes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.AddAttributesToFindingsRequest.ReadOnly =
    zio.aws.inspector.model.AddAttributesToFindingsRequest.wrap(buildAwsValue())
}
object AddAttributesToFindingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.AddAttributesToFindingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.AddAttributesToFindingsRequest =
      zio.aws.inspector.model.AddAttributesToFindingsRequest(
        findingArns,
        attributes.map { item =>
          item.asEditable
        }
      )
    def findingArns: List[Arn]
    def attributes: List[zio.aws.inspector.model.Attribute.ReadOnly]
    def getFindingArns: ZIO[Any, Nothing, List[Arn]] = ZIO.succeed(findingArns)
    def getAttributes
        : ZIO[Any, Nothing, List[zio.aws.inspector.model.Attribute.ReadOnly]] =
      ZIO.succeed(attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.AddAttributesToFindingsRequest
  ) extends zio.aws.inspector.model.AddAttributesToFindingsRequest.ReadOnly {
    override val findingArns: List[Arn] = impl
      .findingArns()
      .asScala
      .map { item =>
        zio.aws.inspector.model.primitives.Arn(item)
      }
      .toList
    override val attributes: List[zio.aws.inspector.model.Attribute.ReadOnly] =
      impl
        .attributes()
        .asScala
        .map { item =>
          zio.aws.inspector.model.Attribute.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.AddAttributesToFindingsRequest
  ): zio.aws.inspector.model.AddAttributesToFindingsRequest.ReadOnly =
    new Wrapper(impl)
}
