package zio.aws.inspector.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.inspector.model.primitives.{
  ListMaxResults,
  PaginationToken,
  UUID,
  Arn
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetExclusionsPreviewRequest(
    assessmentTemplateArn: Arn,
    previewToken: UUID,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[ListMaxResults] = Optional.Absent,
    locale: Optional[zio.aws.inspector.model.Locale] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewRequest = {
    import GetExclusionsPreviewRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewRequest
      .builder()
      .assessmentTemplateArn(
        Arn.unwrap(assessmentTemplateArn): java.lang.String
      )
      .previewToken(UUID.unwrap(previewToken): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ListMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(locale.map(value => value.unwrap))(_.locale)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.GetExclusionsPreviewRequest.ReadOnly =
    zio.aws.inspector.model.GetExclusionsPreviewRequest.wrap(buildAwsValue())
}
object GetExclusionsPreviewRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.GetExclusionsPreviewRequest =
      zio.aws.inspector.model.GetExclusionsPreviewRequest(
        assessmentTemplateArn,
        previewToken,
        nextToken.map(value => value),
        maxResults.map(value => value),
        locale.map(value => value)
      )
    def assessmentTemplateArn: Arn
    def previewToken: UUID
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[ListMaxResults]
    def locale: Optional[zio.aws.inspector.model.Locale]
    def getAssessmentTemplateArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(assessmentTemplateArn)
    def getPreviewToken: ZIO[Any, Nothing, UUID] = ZIO.succeed(previewToken)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getLocale: ZIO[Any, AwsError, zio.aws.inspector.model.Locale] =
      AwsError.unwrapOptionField("locale", locale)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewRequest
  ) extends zio.aws.inspector.model.GetExclusionsPreviewRequest.ReadOnly {
    override val assessmentTemplateArn: Arn =
      zio.aws.inspector.model.primitives.Arn(impl.assessmentTemplateArn())
    override val previewToken: UUID =
      zio.aws.inspector.model.primitives.UUID(impl.previewToken())
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector.model.primitives.PaginationToken(value))
    override val maxResults: Optional[ListMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.inspector.model.primitives.ListMaxResults(value))
    override val locale: Optional[zio.aws.inspector.model.Locale] =
      zio.aws.core.internal
        .optionalFromNullable(impl.locale())
        .map(value => zio.aws.inspector.model.Locale.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewRequest
  ): zio.aws.inspector.model.GetExclusionsPreviewRequest.ReadOnly = new Wrapper(
    impl
  )
}
