package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class AssessmentRunStateChange(
    stateChangedAt: Timestamp,
    state: zio.aws.inspector.model.AssessmentRunState
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.AssessmentRunStateChange = {
    import AssessmentRunStateChange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.AssessmentRunStateChange
      .builder()
      .stateChangedAt(Timestamp.unwrap(stateChangedAt): Instant)
      .state(state.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.AssessmentRunStateChange.ReadOnly =
    zio.aws.inspector.model.AssessmentRunStateChange.wrap(buildAwsValue())
}
object AssessmentRunStateChange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.AssessmentRunStateChange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.AssessmentRunStateChange =
      zio.aws.inspector.model.AssessmentRunStateChange(stateChangedAt, state)
    def stateChangedAt: Timestamp
    def state: zio.aws.inspector.model.AssessmentRunState
    def getStateChangedAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(stateChangedAt)
    def getState
        : ZIO[Any, Nothing, zio.aws.inspector.model.AssessmentRunState] =
      ZIO.succeed(state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.AssessmentRunStateChange
  ) extends zio.aws.inspector.model.AssessmentRunStateChange.ReadOnly {
    override val stateChangedAt: Timestamp =
      zio.aws.inspector.model.primitives.Timestamp(impl.stateChangedAt())
    override val state: zio.aws.inspector.model.AssessmentRunState =
      zio.aws.inspector.model.AssessmentRunState.wrap(impl.state())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.AssessmentRunStateChange
  ): zio.aws.inspector.model.AssessmentRunStateChange.ReadOnly = new Wrapper(
    impl
  )
}
