package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.{Timestamp, Arn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ResourceGroup(
    arn: Arn,
    tags: Iterable[zio.aws.inspector.model.ResourceGroupTag],
    createdAt: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.ResourceGroup = {
    import ResourceGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.ResourceGroup
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.ResourceGroup.ReadOnly =
    zio.aws.inspector.model.ResourceGroup.wrap(buildAwsValue())
}
object ResourceGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.ResourceGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.ResourceGroup =
      zio.aws.inspector.model.ResourceGroup(
        arn,
        tags.map { item =>
          item.asEditable
        },
        createdAt
      )
    def arn: Arn
    def tags: List[zio.aws.inspector.model.ResourceGroupTag.ReadOnly]
    def createdAt: Timestamp
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getTags: ZIO[Any, Nothing, List[
      zio.aws.inspector.model.ResourceGroupTag.ReadOnly
    ]] = ZIO.succeed(tags)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.ResourceGroup
  ) extends zio.aws.inspector.model.ResourceGroup.ReadOnly {
    override val arn: Arn = zio.aws.inspector.model.primitives.Arn(impl.arn())
    override val tags: List[zio.aws.inspector.model.ResourceGroupTag.ReadOnly] =
      impl
        .tags()
        .asScala
        .map { item =>
          zio.aws.inspector.model.ResourceGroupTag.wrap(item)
        }
        .toList
    override val createdAt: Timestamp =
      zio.aws.inspector.model.primitives.Timestamp(impl.createdAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.ResourceGroup
  ): zio.aws.inspector.model.ResourceGroup.ReadOnly = new Wrapper(impl)
}
