package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetAssessmentReportRequest(
    assessmentRunArn: Arn,
    reportFileFormat: zio.aws.inspector.model.ReportFileFormat,
    reportType: zio.aws.inspector.model.ReportType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.GetAssessmentReportRequest = {
    import GetAssessmentReportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.GetAssessmentReportRequest
      .builder()
      .assessmentRunArn(Arn.unwrap(assessmentRunArn): java.lang.String)
      .reportFileFormat(reportFileFormat.unwrap)
      .reportType(reportType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.GetAssessmentReportRequest.ReadOnly =
    zio.aws.inspector.model.GetAssessmentReportRequest.wrap(buildAwsValue())
}
object GetAssessmentReportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.GetAssessmentReportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.GetAssessmentReportRequest =
      zio.aws.inspector.model.GetAssessmentReportRequest(
        assessmentRunArn,
        reportFileFormat,
        reportType
      )
    def assessmentRunArn: Arn
    def reportFileFormat: zio.aws.inspector.model.ReportFileFormat
    def reportType: zio.aws.inspector.model.ReportType
    def getAssessmentRunArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(assessmentRunArn)
    def getReportFileFormat
        : ZIO[Any, Nothing, zio.aws.inspector.model.ReportFileFormat] =
      ZIO.succeed(reportFileFormat)
    def getReportType: ZIO[Any, Nothing, zio.aws.inspector.model.ReportType] =
      ZIO.succeed(reportType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.GetAssessmentReportRequest
  ) extends zio.aws.inspector.model.GetAssessmentReportRequest.ReadOnly {
    override val assessmentRunArn: Arn =
      zio.aws.inspector.model.primitives.Arn(impl.assessmentRunArn())
    override val reportFileFormat: zio.aws.inspector.model.ReportFileFormat =
      zio.aws.inspector.model.ReportFileFormat.wrap(impl.reportFileFormat())
    override val reportType: zio.aws.inspector.model.ReportType =
      zio.aws.inspector.model.ReportType.wrap(impl.reportType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.GetAssessmentReportRequest
  ): zio.aws.inspector.model.GetAssessmentReportRequest.ReadOnly = new Wrapper(
    impl
  )
}
