package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Text
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PrivateIp(
    privateDnsName: Optional[Text] = Optional.Absent,
    privateIpAddress: Optional[Text] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.PrivateIp = {
    import PrivateIp.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.PrivateIp
      .builder()
      .optionallyWith(
        privateDnsName.map(value => Text.unwrap(value): java.lang.String)
      )(_.privateDnsName)
      .optionallyWith(
        privateIpAddress.map(value => Text.unwrap(value): java.lang.String)
      )(_.privateIpAddress)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.PrivateIp.ReadOnly =
    zio.aws.inspector.model.PrivateIp.wrap(buildAwsValue())
}
object PrivateIp {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.PrivateIp
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.PrivateIp =
      zio.aws.inspector.model.PrivateIp(
        privateDnsName.map(value => value),
        privateIpAddress.map(value => value)
      )
    def privateDnsName: Optional[Text]
    def privateIpAddress: Optional[Text]
    def getPrivateDnsName: ZIO[Any, AwsError, Text] =
      AwsError.unwrapOptionField("privateDnsName", privateDnsName)
    def getPrivateIpAddress: ZIO[Any, AwsError, Text] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.PrivateIp
  ) extends zio.aws.inspector.model.PrivateIp.ReadOnly {
    override val privateDnsName: Optional[Text] = zio.aws.core.internal
      .optionalFromNullable(impl.privateDnsName())
      .map(value => zio.aws.inspector.model.primitives.Text(value))
    override val privateIpAddress: Optional[Text] = zio.aws.core.internal
      .optionalFromNullable(impl.privateIpAddress())
      .map(value => zio.aws.inspector.model.primitives.Text(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.PrivateIp
  ): zio.aws.inspector.model.PrivateIp.ReadOnly = new Wrapper(impl)
}
