package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeResourceGroupsResponse(
    resourceGroups: Iterable[zio.aws.inspector.model.ResourceGroup],
    failedItems: Map[Arn, zio.aws.inspector.model.FailedItemDetails]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.DescribeResourceGroupsResponse = {
    import DescribeResourceGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.DescribeResourceGroupsResponse
      .builder()
      .resourceGroups(resourceGroups.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .failedItems(
        failedItems
          .map({ case (key, value) =>
            (Arn.unwrap(key): java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.DescribeResourceGroupsResponse.ReadOnly =
    zio.aws.inspector.model.DescribeResourceGroupsResponse.wrap(buildAwsValue())
}
object DescribeResourceGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.DescribeResourceGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.DescribeResourceGroupsResponse =
      zio.aws.inspector.model.DescribeResourceGroupsResponse(
        resourceGroups.map { item =>
          item.asEditable
        },
        failedItems.map({ case (key, value) =>
          key -> value.asEditable
        })
      )
    def resourceGroups: List[zio.aws.inspector.model.ResourceGroup.ReadOnly]
    def failedItems
        : Map[Arn, zio.aws.inspector.model.FailedItemDetails.ReadOnly]
    def getResourceGroups: ZIO[Any, Nothing, List[
      zio.aws.inspector.model.ResourceGroup.ReadOnly
    ]] = ZIO.succeed(resourceGroups)
    def getFailedItems: ZIO[Any, Nothing, Map[
      Arn,
      zio.aws.inspector.model.FailedItemDetails.ReadOnly
    ]] = ZIO.succeed(failedItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.DescribeResourceGroupsResponse
  ) extends zio.aws.inspector.model.DescribeResourceGroupsResponse.ReadOnly {
    override val resourceGroups
        : List[zio.aws.inspector.model.ResourceGroup.ReadOnly] = impl
      .resourceGroups()
      .asScala
      .map { item =>
        zio.aws.inspector.model.ResourceGroup.wrap(item)
      }
      .toList
    override val failedItems
        : Map[Arn, zio.aws.inspector.model.FailedItemDetails.ReadOnly] = impl
      .failedItems()
      .asScala
      .map({ case (key, value) =>
        zio.aws.inspector.model.primitives
          .Arn(key) -> zio.aws.inspector.model.FailedItemDetails.wrap(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.DescribeResourceGroupsResponse
  ): zio.aws.inspector.model.DescribeResourceGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
