package zio.aws.inspector.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.inspector.model.primitives.{
  ArnCount,
  AssessmentRunDuration,
  Timestamp,
  Arn,
  AssessmentTemplateName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class AssessmentTemplate(
    arn: Arn,
    name: AssessmentTemplateName,
    assessmentTargetArn: Arn,
    durationInSeconds: AssessmentRunDuration,
    rulesPackageArns: Iterable[Arn],
    userAttributesForFindings: Iterable[zio.aws.inspector.model.Attribute],
    lastAssessmentRunArn: Optional[Arn] = Optional.Absent,
    assessmentRunCount: ArnCount,
    createdAt: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.AssessmentTemplate = {
    import AssessmentTemplate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.AssessmentTemplate
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .name(AssessmentTemplateName.unwrap(name): java.lang.String)
      .assessmentTargetArn(Arn.unwrap(assessmentTargetArn): java.lang.String)
      .durationInSeconds(
        AssessmentRunDuration.unwrap(durationInSeconds): Integer
      )
      .rulesPackageArns(rulesPackageArns.map { item =>
        Arn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .userAttributesForFindings(userAttributesForFindings.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        lastAssessmentRunArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.lastAssessmentRunArn)
      .assessmentRunCount(ArnCount.unwrap(assessmentRunCount): Integer)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.AssessmentTemplate.ReadOnly =
    zio.aws.inspector.model.AssessmentTemplate.wrap(buildAwsValue())
}
object AssessmentTemplate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.AssessmentTemplate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.AssessmentTemplate =
      zio.aws.inspector.model.AssessmentTemplate(
        arn,
        name,
        assessmentTargetArn,
        durationInSeconds,
        rulesPackageArns,
        userAttributesForFindings.map { item =>
          item.asEditable
        },
        lastAssessmentRunArn.map(value => value),
        assessmentRunCount,
        createdAt
      )
    def arn: Arn
    def name: AssessmentTemplateName
    def assessmentTargetArn: Arn
    def durationInSeconds: AssessmentRunDuration
    def rulesPackageArns: List[Arn]
    def userAttributesForFindings
        : List[zio.aws.inspector.model.Attribute.ReadOnly]
    def lastAssessmentRunArn: Optional[Arn]
    def assessmentRunCount: ArnCount
    def createdAt: Timestamp
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getName: ZIO[Any, Nothing, AssessmentTemplateName] = ZIO.succeed(name)
    def getAssessmentTargetArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(assessmentTargetArn)
    def getDurationInSeconds: ZIO[Any, Nothing, AssessmentRunDuration] =
      ZIO.succeed(durationInSeconds)
    def getRulesPackageArns: ZIO[Any, Nothing, List[Arn]] =
      ZIO.succeed(rulesPackageArns)
    def getUserAttributesForFindings
        : ZIO[Any, Nothing, List[zio.aws.inspector.model.Attribute.ReadOnly]] =
      ZIO.succeed(userAttributesForFindings)
    def getLastAssessmentRunArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("lastAssessmentRunArn", lastAssessmentRunArn)
    def getAssessmentRunCount: ZIO[Any, Nothing, ArnCount] =
      ZIO.succeed(assessmentRunCount)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.AssessmentTemplate
  ) extends zio.aws.inspector.model.AssessmentTemplate.ReadOnly {
    override val arn: Arn = zio.aws.inspector.model.primitives.Arn(impl.arn())
    override val name: AssessmentTemplateName =
      zio.aws.inspector.model.primitives.AssessmentTemplateName(impl.name())
    override val assessmentTargetArn: Arn =
      zio.aws.inspector.model.primitives.Arn(impl.assessmentTargetArn())
    override val durationInSeconds: AssessmentRunDuration =
      zio.aws.inspector.model.primitives
        .AssessmentRunDuration(impl.durationInSeconds())
    override val rulesPackageArns: List[Arn] = impl
      .rulesPackageArns()
      .asScala
      .map { item =>
        zio.aws.inspector.model.primitives.Arn(item)
      }
      .toList
    override val userAttributesForFindings
        : List[zio.aws.inspector.model.Attribute.ReadOnly] = impl
      .userAttributesForFindings()
      .asScala
      .map { item =>
        zio.aws.inspector.model.Attribute.wrap(item)
      }
      .toList
    override val lastAssessmentRunArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.lastAssessmentRunArn())
      .map(value => zio.aws.inspector.model.primitives.Arn(value))
    override val assessmentRunCount: ArnCount =
      zio.aws.inspector.model.primitives.ArnCount(impl.assessmentRunCount())
    override val createdAt: Timestamp =
      zio.aws.inspector.model.primitives.Timestamp(impl.createdAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.AssessmentTemplate
  ): zio.aws.inspector.model.AssessmentTemplate.ReadOnly = new Wrapper(impl)
}
