package zio.aws.inspector.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.inspector.model.primitives.{ListMaxResults, PaginationToken, Arn}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAssessmentTemplatesRequest(
    assessmentTargetArns: Optional[Iterable[Arn]] = Optional.Absent,
    filter: Optional[zio.aws.inspector.model.AssessmentTemplateFilter] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[ListMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesRequest = {
    import ListAssessmentTemplatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesRequest
      .builder()
      .optionallyWith(
        assessmentTargetArns.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.assessmentTargetArns)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ListMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.ListAssessmentTemplatesRequest.ReadOnly =
    zio.aws.inspector.model.ListAssessmentTemplatesRequest.wrap(buildAwsValue())
}
object ListAssessmentTemplatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.ListAssessmentTemplatesRequest =
      zio.aws.inspector.model.ListAssessmentTemplatesRequest(
        assessmentTargetArns.map(value => value),
        filter.map(value => value.asEditable),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def assessmentTargetArns: Optional[List[Arn]]
    def filter
        : Optional[zio.aws.inspector.model.AssessmentTemplateFilter.ReadOnly]
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[ListMaxResults]
    def getAssessmentTargetArns: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("assessmentTargetArns", assessmentTargetArns)
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.inspector.model.AssessmentTemplateFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesRequest
  ) extends zio.aws.inspector.model.ListAssessmentTemplatesRequest.ReadOnly {
    override val assessmentTargetArns: Optional[List[Arn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assessmentTargetArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector.model.primitives.Arn(item)
          }.toList
        )
    override val filter
        : Optional[zio.aws.inspector.model.AssessmentTemplateFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value =>
          zio.aws.inspector.model.AssessmentTemplateFilter.wrap(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector.model.primitives.PaginationToken(value))
    override val maxResults: Optional[ListMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.inspector.model.primitives.ListMaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesRequest
  ): zio.aws.inspector.model.ListAssessmentTemplatesRequest.ReadOnly =
    new Wrapper(impl)
}
