package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class EventSubscription(
    event: zio.aws.inspector.model.InspectorEvent,
    subscribedAt: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.EventSubscription = {
    import EventSubscription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.EventSubscription
      .builder()
      .event(event.unwrap)
      .subscribedAt(Timestamp.unwrap(subscribedAt): Instant)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.EventSubscription.ReadOnly =
    zio.aws.inspector.model.EventSubscription.wrap(buildAwsValue())
}
object EventSubscription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.EventSubscription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.EventSubscription =
      zio.aws.inspector.model.EventSubscription(event, subscribedAt)
    def event: zio.aws.inspector.model.InspectorEvent
    def subscribedAt: Timestamp
    def getEvent: ZIO[Any, Nothing, zio.aws.inspector.model.InspectorEvent] =
      ZIO.succeed(event)
    def getSubscribedAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(subscribedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.EventSubscription
  ) extends zio.aws.inspector.model.EventSubscription.ReadOnly {
    override val event: zio.aws.inspector.model.InspectorEvent =
      zio.aws.inspector.model.InspectorEvent.wrap(impl.event())
    override val subscribedAt: Timestamp =
      zio.aws.inspector.model.primitives.Timestamp(impl.subscribedAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.EventSubscription
  ): zio.aws.inspector.model.EventSubscription.ReadOnly = new Wrapper(impl)
}
