package zio.aws.inspector.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.inspector.model.primitives.{ListMaxResults, PaginationToken, Arn}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAssessmentRunAgentsRequest(
    assessmentRunArn: Arn,
    filter: Optional[zio.aws.inspector.model.AgentFilter] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[ListMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsRequest = {
    import ListAssessmentRunAgentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsRequest
      .builder()
      .assessmentRunArn(Arn.unwrap(assessmentRunArn): java.lang.String)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ListMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.ListAssessmentRunAgentsRequest.ReadOnly =
    zio.aws.inspector.model.ListAssessmentRunAgentsRequest.wrap(buildAwsValue())
}
object ListAssessmentRunAgentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.ListAssessmentRunAgentsRequest =
      zio.aws.inspector.model.ListAssessmentRunAgentsRequest(
        assessmentRunArn,
        filter.map(value => value.asEditable),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def assessmentRunArn: Arn
    def filter: Optional[zio.aws.inspector.model.AgentFilter.ReadOnly]
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[ListMaxResults]
    def getAssessmentRunArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(assessmentRunArn)
    def getFilter
        : ZIO[Any, AwsError, zio.aws.inspector.model.AgentFilter.ReadOnly] =
      AwsError.unwrapOptionField("filter", filter)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsRequest
  ) extends zio.aws.inspector.model.ListAssessmentRunAgentsRequest.ReadOnly {
    override val assessmentRunArn: Arn =
      zio.aws.inspector.model.primitives.Arn(impl.assessmentRunArn())
    override val filter
        : Optional[zio.aws.inspector.model.AgentFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.inspector.model.AgentFilter.wrap(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector.model.primitives.PaginationToken(value))
    override val maxResults: Optional[ListMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.inspector.model.primitives.ListMaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsRequest
  ): zio.aws.inspector.model.ListAssessmentRunAgentsRequest.ReadOnly =
    new Wrapper(impl)
}
