package zio.aws.inspector.model
import scala.jdk.CollectionConverters._
sealed trait PreviewStatus {
  def unwrap: software.amazon.awssdk.services.inspector.model.PreviewStatus
}
object PreviewStatus {
  def wrap(
      value: software.amazon.awssdk.services.inspector.model.PreviewStatus
  ): zio.aws.inspector.model.PreviewStatus = value match {
    case software.amazon.awssdk.services.inspector.model.PreviewStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector.model.PreviewStatus.WORK_IN_PROGRESS =>
      val r = WORK_IN_PROGRESS
      r
    case software.amazon.awssdk.services.inspector.model.PreviewStatus.COMPLETED =>
      val r = COMPLETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector.model.PreviewStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.PreviewStatus =
      software.amazon.awssdk.services.inspector.model.PreviewStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object WORK_IN_PROGRESS extends zio.aws.inspector.model.PreviewStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.PreviewStatus =
      software.amazon.awssdk.services.inspector.model.PreviewStatus.WORK_IN_PROGRESS
  }
  case object COMPLETED extends zio.aws.inspector.model.PreviewStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.PreviewStatus =
      software.amazon.awssdk.services.inspector.model.PreviewStatus.COMPLETED
  }
}
