package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.{Timestamp, Bool, Arn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeCrossAccountAccessRoleResponse(
    roleArn: Arn,
    valid: Bool,
    registeredAt: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.DescribeCrossAccountAccessRoleResponse = {
    import DescribeCrossAccountAccessRoleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.DescribeCrossAccountAccessRoleResponse
      .builder()
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .valid(valid: java.lang.Boolean)
      .registeredAt(Timestamp.unwrap(registeredAt): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.DescribeCrossAccountAccessRoleResponse.ReadOnly =
    zio.aws.inspector.model.DescribeCrossAccountAccessRoleResponse
      .wrap(buildAwsValue())
}
object DescribeCrossAccountAccessRoleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.DescribeCrossAccountAccessRoleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector.model.DescribeCrossAccountAccessRoleResponse =
      zio.aws.inspector.model
        .DescribeCrossAccountAccessRoleResponse(roleArn, valid, registeredAt)
    def roleArn: Arn
    def valid: Bool
    def registeredAt: Timestamp
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getValid: ZIO[Any, Nothing, Bool] = ZIO.succeed(valid)
    def getRegisteredAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(registeredAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.DescribeCrossAccountAccessRoleResponse
  ) extends zio.aws.inspector.model.DescribeCrossAccountAccessRoleResponse.ReadOnly {
    override val roleArn: Arn =
      zio.aws.inspector.model.primitives.Arn(impl.roleArn())
    override val valid: Bool = impl.valid(): Bool
    override val registeredAt: Timestamp =
      zio.aws.inspector.model.primitives.Timestamp(impl.registeredAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.DescribeCrossAccountAccessRoleResponse
  ): zio.aws.inspector.model.DescribeCrossAccountAccessRoleResponse.ReadOnly =
    new Wrapper(impl)
}
