package zio.aws.inspector.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.inspector.model.primitives.{
  AssessmentRunDuration,
  AssessmentTemplateName,
  Arn
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateAssessmentTemplateRequest(
    assessmentTargetArn: Arn,
    assessmentTemplateName: AssessmentTemplateName,
    durationInSeconds: AssessmentRunDuration,
    rulesPackageArns: Iterable[Arn],
    userAttributesForFindings: Optional[
      Iterable[zio.aws.inspector.model.Attribute]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.CreateAssessmentTemplateRequest = {
    import CreateAssessmentTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.CreateAssessmentTemplateRequest
      .builder()
      .assessmentTargetArn(Arn.unwrap(assessmentTargetArn): java.lang.String)
      .assessmentTemplateName(
        AssessmentTemplateName.unwrap(assessmentTemplateName): java.lang.String
      )
      .durationInSeconds(
        AssessmentRunDuration.unwrap(durationInSeconds): Integer
      )
      .rulesPackageArns(rulesPackageArns.map { item =>
        Arn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        userAttributesForFindings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userAttributesForFindings)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.CreateAssessmentTemplateRequest.ReadOnly =
    zio.aws.inspector.model.CreateAssessmentTemplateRequest
      .wrap(buildAwsValue())
}
object CreateAssessmentTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.CreateAssessmentTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.CreateAssessmentTemplateRequest =
      zio.aws.inspector.model.CreateAssessmentTemplateRequest(
        assessmentTargetArn,
        assessmentTemplateName,
        durationInSeconds,
        rulesPackageArns,
        userAttributesForFindings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def assessmentTargetArn: Arn
    def assessmentTemplateName: AssessmentTemplateName
    def durationInSeconds: AssessmentRunDuration
    def rulesPackageArns: List[Arn]
    def userAttributesForFindings
        : Optional[List[zio.aws.inspector.model.Attribute.ReadOnly]]
    def getAssessmentTargetArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(assessmentTargetArn)
    def getAssessmentTemplateName: ZIO[Any, Nothing, AssessmentTemplateName] =
      ZIO.succeed(assessmentTemplateName)
    def getDurationInSeconds: ZIO[Any, Nothing, AssessmentRunDuration] =
      ZIO.succeed(durationInSeconds)
    def getRulesPackageArns: ZIO[Any, Nothing, List[Arn]] =
      ZIO.succeed(rulesPackageArns)
    def getUserAttributesForFindings
        : ZIO[Any, AwsError, List[zio.aws.inspector.model.Attribute.ReadOnly]] =
      AwsError.unwrapOptionField(
        "userAttributesForFindings",
        userAttributesForFindings
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.CreateAssessmentTemplateRequest
  ) extends zio.aws.inspector.model.CreateAssessmentTemplateRequest.ReadOnly {
    override val assessmentTargetArn: Arn =
      zio.aws.inspector.model.primitives.Arn(impl.assessmentTargetArn())
    override val assessmentTemplateName: AssessmentTemplateName =
      zio.aws.inspector.model.primitives
        .AssessmentTemplateName(impl.assessmentTemplateName())
    override val durationInSeconds: AssessmentRunDuration =
      zio.aws.inspector.model.primitives
        .AssessmentRunDuration(impl.durationInSeconds())
    override val rulesPackageArns: List[Arn] = impl
      .rulesPackageArns()
      .asScala
      .map { item =>
        zio.aws.inspector.model.primitives.Arn(item)
      }
      .toList
    override val userAttributesForFindings
        : Optional[List[zio.aws.inspector.model.Attribute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userAttributesForFindings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector.model.Attribute.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.CreateAssessmentTemplateRequest
  ): zio.aws.inspector.model.CreateAssessmentTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
