package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateExclusionsPreviewRequest(assessmentTemplateArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.CreateExclusionsPreviewRequest = {
    import CreateExclusionsPreviewRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.CreateExclusionsPreviewRequest
      .builder()
      .assessmentTemplateArn(
        Arn.unwrap(assessmentTemplateArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.CreateExclusionsPreviewRequest.ReadOnly =
    zio.aws.inspector.model.CreateExclusionsPreviewRequest.wrap(buildAwsValue())
}
object CreateExclusionsPreviewRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.CreateExclusionsPreviewRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.CreateExclusionsPreviewRequest =
      zio.aws.inspector.model
        .CreateExclusionsPreviewRequest(assessmentTemplateArn)
    def assessmentTemplateArn: Arn
    def getAssessmentTemplateArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(assessmentTemplateArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.CreateExclusionsPreviewRequest
  ) extends zio.aws.inspector.model.CreateExclusionsPreviewRequest.ReadOnly {
    override val assessmentTemplateArn: Arn =
      zio.aws.inspector.model.primitives.Arn(impl.assessmentTemplateArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.CreateExclusionsPreviewRequest
  ): zio.aws.inspector.model.CreateExclusionsPreviewRequest.ReadOnly =
    new Wrapper(impl)
}
