package zio.aws.inspector.model
import scala.jdk.CollectionConverters._
sealed trait Severity {
  def unwrap: software.amazon.awssdk.services.inspector.model.Severity
}
object Severity {
  def wrap(
      value: software.amazon.awssdk.services.inspector.model.Severity
  ): zio.aws.inspector.model.Severity = value match {
    case software.amazon.awssdk.services.inspector.model.Severity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector.model.Severity.LOW =>
      val r = Low
      r
    case software.amazon.awssdk.services.inspector.model.Severity.MEDIUM =>
      val r = Medium
      r
    case software.amazon.awssdk.services.inspector.model.Severity.HIGH =>
      val r = High
      r
    case software.amazon.awssdk.services.inspector.model.Severity.INFORMATIONAL =>
      val r = Informational
      r
    case software.amazon.awssdk.services.inspector.model.Severity.UNDEFINED =>
      val r = Undefined
      r
  }
  case object unknownToSdkVersion extends zio.aws.inspector.model.Severity {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.Severity =
      software.amazon.awssdk.services.inspector.model.Severity.UNKNOWN_TO_SDK_VERSION
  }
  case object Low extends zio.aws.inspector.model.Severity {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.Severity =
      software.amazon.awssdk.services.inspector.model.Severity.LOW
  }
  case object Medium extends zio.aws.inspector.model.Severity {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.Severity =
      software.amazon.awssdk.services.inspector.model.Severity.MEDIUM
  }
  case object High extends zio.aws.inspector.model.Severity {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.Severity =
      software.amazon.awssdk.services.inspector.model.Severity.HIGH
  }
  case object Informational extends zio.aws.inspector.model.Severity {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.Severity =
      software.amazon.awssdk.services.inspector.model.Severity.INFORMATIONAL
  }
  case object Undefined extends zio.aws.inspector.model.Severity {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.Severity =
      software.amazon.awssdk.services.inspector.model.Severity.UNDEFINED
  }
}
