package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeExclusionsRequest(
    exclusionArns: Iterable[Arn],
    locale: Optional[zio.aws.inspector.model.Locale] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.DescribeExclusionsRequest = {
    import DescribeExclusionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.DescribeExclusionsRequest
      .builder()
      .exclusionArns(exclusionArns.map { item =>
        Arn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(locale.map(value => value.unwrap))(_.locale)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.DescribeExclusionsRequest.ReadOnly =
    zio.aws.inspector.model.DescribeExclusionsRequest.wrap(buildAwsValue())
}
object DescribeExclusionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.DescribeExclusionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.DescribeExclusionsRequest =
      zio.aws.inspector.model
        .DescribeExclusionsRequest(exclusionArns, locale.map(value => value))
    def exclusionArns: List[Arn]
    def locale: Optional[zio.aws.inspector.model.Locale]
    def getExclusionArns: ZIO[Any, Nothing, List[Arn]] =
      ZIO.succeed(exclusionArns)
    def getLocale: ZIO[Any, AwsError, zio.aws.inspector.model.Locale] =
      AwsError.unwrapOptionField("locale", locale)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.DescribeExclusionsRequest
  ) extends zio.aws.inspector.model.DescribeExclusionsRequest.ReadOnly {
    override val exclusionArns: List[Arn] = impl
      .exclusionArns()
      .asScala
      .map { item =>
        zio.aws.inspector.model.primitives.Arn(item)
      }
      .toList
    override val locale: Optional[zio.aws.inspector.model.Locale] =
      zio.aws.core.internal
        .optionalFromNullable(impl.locale())
        .map(value => zio.aws.inspector.model.Locale.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.DescribeExclusionsRequest
  ): zio.aws.inspector.model.DescribeExclusionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
