package zio.aws.inspector.model
import scala.jdk.CollectionConverters._
sealed trait Locale {
  def unwrap: software.amazon.awssdk.services.inspector.model.Locale
}
object Locale {
  def wrap(
      value: software.amazon.awssdk.services.inspector.model.Locale
  ): zio.aws.inspector.model.Locale = value match {
    case software.amazon.awssdk.services.inspector.model.Locale.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector.model.Locale.EN_US =>
      val r = EN_US
      r
  }
  case object unknownToSdkVersion extends zio.aws.inspector.model.Locale {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.Locale =
      software.amazon.awssdk.services.inspector.model.Locale.UNKNOWN_TO_SDK_VERSION
  }
  case object EN_US extends zio.aws.inspector.model.Locale {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.Locale =
      software.amazon.awssdk.services.inspector.model.Locale.EN_US
  }
}
