package zio.aws.inspector.model
import scala.jdk.CollectionConverters._
sealed trait StopAction {
  def unwrap: software.amazon.awssdk.services.inspector.model.StopAction
}
object StopAction {
  def wrap(
      value: software.amazon.awssdk.services.inspector.model.StopAction
  ): zio.aws.inspector.model.StopAction = value match {
    case software.amazon.awssdk.services.inspector.model.StopAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector.model.StopAction.START_EVALUATION =>
      val r = START_EVALUATION
      r
    case software.amazon.awssdk.services.inspector.model.StopAction.SKIP_EVALUATION =>
      val r = SKIP_EVALUATION
      r
  }
  case object unknownToSdkVersion extends zio.aws.inspector.model.StopAction {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.StopAction =
      software.amazon.awssdk.services.inspector.model.StopAction.UNKNOWN_TO_SDK_VERSION
  }
  case object START_EVALUATION extends zio.aws.inspector.model.StopAction {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.StopAction =
      software.amazon.awssdk.services.inspector.model.StopAction.START_EVALUATION
  }
  case object SKIP_EVALUATION extends zio.aws.inspector.model.StopAction {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.StopAction =
      software.amazon.awssdk.services.inspector.model.StopAction.SKIP_EVALUATION
  }
}
